/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.jsp.tag;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class PlaceholderTag
extends TagSupport {
    private static final long serialVersionUID = -8657669703834740046L;
    private static final String PLACEHOLDER_TYPE_JS = "js";
    private static final String PLACEHOLDER_TYPE_CSS = "css";
    private String placeholderType;

    public int doEndTag() throws JspException {
        String existingPlaceholder;
        String placeholder = "dandelionPlaceholder" + this.placeholderType;
        if (PLACEHOLDER_TYPE_JS.equalsIgnoreCase(this.placeholderType)) {
            existingPlaceholder = AssetRequestContext.get((ServletRequest)this.pageContext.getRequest()).getJsPlaceholder();
            if (StringUtils.isNotBlank((String)existingPlaceholder)) {
                throw new JspException("The placeholder type \"js\" can be used only once in the same page");
            }
            AssetRequestContext.get((ServletRequest)this.pageContext.getRequest()).setJsPlaceholder(placeholder);
        } else if (PLACEHOLDER_TYPE_CSS.equalsIgnoreCase(this.placeholderType)) {
            existingPlaceholder = AssetRequestContext.get((ServletRequest)this.pageContext.getRequest()).getCssPlaceholder();
            if (StringUtils.isNotBlank((String)existingPlaceholder)) {
                throw new JspException("The placeholder type \"css\" can be used only once in the same page");
            }
            AssetRequestContext.get((ServletRequest)this.pageContext.getRequest()).setCssPlaceholder(placeholder);
        } else {
            throw new JspException("Only \"js\" and \"css\" are allowed in the \"type\" attribute");
        }
        try {
            this.pageContext.getOut().println(placeholder);
        }
        catch (IOException e) {
            throw new JspException("Unable to update the page with a HTML placeholder", (Throwable)e);
        }
        return 6;
    }

    public void setType(String placeholderType) throws JspException {
        if (StringUtils.isBlank((String)placeholderType)) {
            throw new JspException("The \"type\" attribute cannot be blank. Possible values: \"js\" or \"css\"");
        }
        this.placeholderType = placeholderType;
    }
}

