/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.extras.export.itext;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

public class PdfExport
implements DatatablesExport {
    private HtmlTable htmlTable;
    private ExportConf exportConf;

    public void initExport(HtmlTable table) {
        this.htmlTable = table;
        if (table.getTableConfiguration().getExportConfs() != null && table.getTableConfiguration().getExportConf(ExportType.PDF) != null) {
            this.exportConf = table.getTableConfiguration().getExportConf(ExportType.PDF);
        }
    }

    public void processExport(OutputStream output) throws ExportException {
        Document document = new Document();
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)output);
            pdfWriter.setViewerPreferences(1);
            document.open();
            this.addTitle(document);
            this.addTable(document);
        }
        catch (DocumentException e) {
            throw new ExportException((Throwable)e);
        }
        finally {
            document.close();
        }
    }

    private void addTitle(Document document) throws DocumentException {
        Paragraph title = new Paragraph("Export");
        title.add((Element)new Paragraph(" "));
        title.setAlignment(1);
        document.add((Element)title);
    }

    private void addTable(Document document) throws DocumentException {
        PdfPCell cell = null;
        int columnCount = 0;
        Iterator i$ = this.htmlTable.getBodyRows().iterator();
        if (i$.hasNext()) {
            HtmlRow htmlRow = (HtmlRow)i$.next();
            for (HtmlColumn column : htmlRow.getColumns()) {
                Set enabledDisplayTypes = column.getEnabledDisplayTypes();
                if (enabledDisplayTypes == null || !enabledDisplayTypes.contains(DisplayType.ALL) && !enabledDisplayTypes.contains(DisplayType.PDF)) continue;
                ++columnCount;
            }
        }
        if (columnCount != 0) {
            Set enabledDisplayTypes;
            PdfPTable table = new PdfPTable(columnCount);
            table.setWidthPercentage(100.0f);
            if (this.exportConf != null && this.exportConf.getIncludeHeader().booleanValue()) {
                for (HtmlRow htmlRow : this.htmlTable.getHeadRows()) {
                    for (HtmlColumn column : htmlRow.getColumns()) {
                        enabledDisplayTypes = column.getEnabledDisplayTypes();
                        if (enabledDisplayTypes == null || !enabledDisplayTypes.contains(DisplayType.ALL) && !enabledDisplayTypes.contains(DisplayType.PDF)) continue;
                        cell = new PdfPCell();
                        cell.setPhrase(new Phrase(column.getContent().toString()));
                        table.addCell(cell);
                    }
                }
            }
            for (HtmlRow htmlRow : this.htmlTable.getBodyRows()) {
                for (HtmlColumn column : htmlRow.getColumns()) {
                    enabledDisplayTypes = column.getEnabledDisplayTypes();
                    if (enabledDisplayTypes == null || !enabledDisplayTypes.contains(DisplayType.ALL) && !enabledDisplayTypes.contains(DisplayType.PDF)) continue;
                    cell = new PdfPCell();
                    cell.setPhrase(new Phrase(column.getContent().toString()));
                    table.addCell(cell);
                }
            }
            document.add((Element)table);
        }
    }
}

