/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.util.EnumUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.option.Callback;
import com.github.dandelion.datatables.core.option.CallbackType;
import com.github.dandelion.datatables.core.util.ProcessorUtils;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class CallbackTag
extends TagSupport {
    private static final long serialVersionUID = -3453884184847355817L;
    private String type;
    private String function;
    private HttpServletRequest request;

    public int doStartTag() throws JspException {
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        TableTag parent = (TableTag)CallbackTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 0;
        }
        throw new JspException("The tag 'callback' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)CallbackTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            CallbackType callbackType = null;
            try {
                callbackType = CallbackType.valueOf((String)this.type.toUpperCase().trim());
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(this.type);
                sb.append("' is not a valid callback type. Possible values are: ");
                sb.append(EnumUtils.printPossibleValuesOf(CallbackType.class));
                throw new JspException(sb.toString(), (Throwable)e);
            }
            this.function = ProcessorUtils.getValueAfterProcessingBundles((String)this.function, (HttpServletRequest)this.request);
            if (parent.getTable().getTableConfiguration().hasCallback(callbackType).booleanValue()) {
                parent.getTable().getTableConfiguration().getCallback(callbackType).appendCode((callbackType.hasReturn() ? "return " : "") + this.function + "(" + StringUtils.join((Object[])callbackType.getArgs(), (String)",") + ");");
            } else {
                parent.getTable().getTableConfiguration().registerCallback(new Callback(callbackType, (callbackType.hasReturn() ? "return " : "") + this.function + "(" + StringUtils.join((Object[])callbackType.getArgs(), (String)",") + ");"));
            }
        }
        return 6;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFunction(String function) {
        this.function = function;
    }
}

