/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.html.HtmlCaption;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.Tag;

public class CaptionTag
extends BodyTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = 273025310498552490L;
    private String id;
    private String cssClass;
    private String cssStyle;
    private String title;
    private boolean escapeXml = true;
    protected Map<String, String> dynamicAttributes;

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)CaptionTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 2;
        }
        throw new JspException("The tag 'caption' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)CaptionTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            HtmlCaption caption = new HtmlCaption();
            caption.setId(this.id);
            caption.addCssClass(this.cssClass);
            caption.addCssStyle(this.cssStyle);
            caption.setTitle(StringUtils.escape((boolean)this.escapeXml, (String)this.title));
            caption.addContent(this.getBodyContent().getString());
            parent.getTable().setCaption(caption);
        }
        return 6;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.validateDynamicAttribute(localName, value);
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(localName, (String)value);
    }

    private void validateDynamicAttribute(String localName, Object value) {
        if (localName.equals("class")) {
            throw new IllegalArgumentException("The 'class' attribute is not allowed. Please use the 'cssClass' attribute instead.");
        }
        if (localName.equals("style")) {
            throw new IllegalArgumentException("The 'style' attribute is not allowed. Please use the 'cssStyle' attribute instead.");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The attribute " + localName + " won't be added to the table. Only string values are accepted.");
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }
}

