/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.generator.AssetContentGenerator;
import com.github.dandelion.core.asset.generator.js.jquery.JQueryContent;
import com.github.dandelion.core.asset.generator.js.jquery.JQueryJsContentGenerator;
import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.OptionUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.util.UrlUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.datatables.core.DatatableBundles;
import com.github.dandelion.datatables.core.export.ExportDelegate;
import com.github.dandelion.datatables.core.export.ExportUtils;
import com.github.dandelion.datatables.core.generator.DatatableJQueryContent;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTag
extends BodyTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = 8770764721128212100L;
    private static Logger logger = LoggerFactory.getLogger(TableTag.class);
    public static final String SOURCE_DOM = "DOM";
    public static final String SOURCE_AJAX = "AJAX";
    private String id;
    private String row;
    private String confGroup;
    private String rowIdBase;
    private String rowIdPrefix;
    private String rowIdSuffix;
    private Object currentObject;
    private Integer iterationNumber;
    private boolean escapeXml = true;
    private Map<Option<?>, Object> stagingOptions = new HashMap();
    private HtmlTable table;
    private Iterator<Object> iterator;
    private String dataSourceType;
    private Map<String, String> dynamicAttributes;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public int doStartTag() throws JspException {
        this.iterationNumber = 1;
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        this.response = (HttpServletResponse)this.pageContext.getResponse();
        this.table = new HtmlTable(this.id, this.request, this.response, this.confGroup, this.dynamicAttributes);
        this.request.setAttribute(TableConfiguration.class.getCanonicalName(), (Object)this.table.getTableConfiguration());
        if (SOURCE_AJAX.equals(this.dataSourceType)) {
            this.table.addHeaderRow();
            return 2;
        }
        if (SOURCE_DOM.equals(this.dataSourceType)) {
            this.table.addHeaderRow();
            return this.processIteration();
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        TableTag tableTag = this;
        Integer n = tableTag.iterationNumber;
        Integer n2 = tableTag.iterationNumber = Integer.valueOf(tableTag.iterationNumber + 1);
        return this.processIteration();
    }

    public int doEndTag() throws JspException {
        this.table.getTableConfiguration().getOptions().putAll(this.stagingOptions);
        OptionUtils.processOptions((Map)this.table.getTableConfiguration().getOptions(), (HttpServletRequest)this.request);
        if (ExportUtils.isTableBeingExported((ServletRequest)this.request, (HtmlTable)this.table).booleanValue()) {
            return this.setupExport();
        }
        if (this.request.getAttribute("ddl-dt-tables") == null) {
            ArrayList<HtmlTable> htmlTables = new ArrayList<HtmlTable>();
            htmlTables.add(this.table);
            this.request.setAttribute("ddl-dt-tables", htmlTables);
        } else {
            List htmlTables = (List)this.request.getAttribute("ddl-dt-tables");
            htmlTables.add(this.table);
        }
        return this.setupHtmlGeneration();
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.validateDynamicAttribute(localName, value);
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(localName, (String)value);
    }

    private int processIteration() throws JspException {
        if (SOURCE_DOM.equals(this.dataSourceType)) {
            Integer retval = null;
            if (this.iterator != null && this.iterator.hasNext()) {
                String rowId;
                Object object = this.iterator.next();
                this.setCurrentObject(object);
                this.stagingOptions.put(DatatableOptions.INTERNAL_OBJECTTYPE, object.getClass().getSimpleName());
                if (this.row != null) {
                    this.pageContext.setAttribute(this.row, object);
                    this.pageContext.setAttribute(this.row + "_rowIndex", (Object)this.iterationNumber);
                }
                if (StringUtils.isNotBlank((String)(rowId = this.getRowId()))) {
                    this.table.addRow(rowId);
                } else {
                    this.table.addRow();
                }
                retval = 2;
            } else {
                retval = 0;
            }
            if (this.isFirstIteration()) {
                retval = 2;
            }
            return retval;
        }
        return 0;
    }

    private String getRowId() throws JspException {
        StringBuilder rowId = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.rowIdPrefix)) {
            rowId.append(StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdPrefix));
        }
        if (StringUtils.isNotBlank((String)this.rowIdBase)) {
            try {
                Object propertyValue = PropertyUtils.getNestedProperty((Object)this.currentObject, (String)StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdBase));
                rowId.append(propertyValue != null ? propertyValue : "");
            }
            catch (IllegalAccessException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)this.rowIdSuffix)) {
            rowId.append(StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdSuffix));
        }
        return rowId.toString();
    }

    private int setupHtmlGeneration() throws JspException {
        this.table.getTableConfiguration().setExporting(Boolean.valueOf(false));
        DatatableJQueryContent datatableContent = new DatatableJQueryContent(this.table);
        JQueryJsContentGenerator javascriptGenerator = (JQueryJsContentGenerator)AssetRequestContext.get((ServletRequest)this.request).getGenerator("ddl-dt");
        if (javascriptGenerator == null) {
            javascriptGenerator = new JQueryJsContentGenerator((JQueryContent)datatableContent);
        } else {
            javascriptGenerator.appendContent((JQueryContent)datatableContent);
        }
        AssetRequestContext.get((ServletRequest)this.request).addBundles(new Enum[]{DatatableBundles.DDL_DT}).addGenerator("ddl-dt", (AssetContentGenerator)javascriptGenerator);
        try {
            this.pageContext.getOut().println((Object)this.table.toHtml());
        }
        catch (IOException e) {
            throw new JspException("Unable to generate the HTML markup for the table " + this.id, (Throwable)e);
        }
        return 6;
    }

    private int setupExport() throws JspException {
        String currentExportType = ExportUtils.getCurrentExportType((HttpServletRequest)this.request);
        this.table.getTableConfiguration().setExporting(Boolean.valueOf(true));
        this.table.getTableConfiguration().setCurrentExportFormat(currentExportType);
        try {
            ExportDelegate exportDelegate = new ExportDelegate(this.table, this.request);
            exportDelegate.prepareExport();
        }
        catch (DandelionException e) {
            logger.error("Something went wront with the Dandelion export configuration.");
            throw new JspException((Throwable)e);
        }
        this.response.reset();
        return 5;
    }

    private void validateDynamicAttribute(String localName, Object value) {
        if (localName.equals("class")) {
            throw new IllegalArgumentException("The 'class' attribute is not allowed. Please use the 'cssClass' attribute instead.");
        }
        if (localName.equals("style")) {
            throw new IllegalArgumentException("The 'style' attribute is not allowed. Please use the 'cssStyle' attribute instead.");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The attribute " + localName + " won't be added to the table. Only string values are accepted.");
        }
    }

    public HtmlTable getTable() {
        return this.table;
    }

    public boolean isFirstIteration() {
        return this.iterationNumber.equals(1);
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public Map<Option<?>, Object> getStagingOptions() {
        return this.stagingOptions;
    }

    public void setCurrentObject(Object currentObject) {
        this.currentObject = currentObject;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public void setData(Collection<Object> data) {
        this.dataSourceType = SOURCE_DOM;
        Collection<Object> dataTmp = data;
        if (dataTmp != null && dataTmp.size() > 0) {
            this.iterator = dataTmp.iterator();
        } else {
            this.iterator = null;
            this.currentObject = null;
        }
    }

    public void setUrl(String url) {
        String processedUrl = UrlUtils.getProcessedUrl((String)url, (HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()), (HttpServletResponse)((HttpServletResponse)this.pageContext.getResponse()));
        this.stagingOptions.put(DatatableOptions.AJAX_SOURCE, processedUrl);
        this.dataSourceType = SOURCE_AJAX;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public void setConfGroup(String confGroup) {
        this.confGroup = confGroup;
    }

    public void setRowIdBase(String rowIdBase) {
        this.rowIdBase = rowIdBase;
    }

    public void setRowIdPrefix(String rowIdPrefix) {
        this.rowIdPrefix = rowIdPrefix;
    }

    public void setRowIdSuffix(String rowIdSuffix) {
        this.rowIdSuffix = rowIdSuffix;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public void setAutoWidth(boolean autoWidth) {
        this.stagingOptions.put(DatatableOptions.FEATURE_AUTOWIDTH, autoWidth);
    }

    public void setDeferRender(String deferRender) {
        this.stagingOptions.put(DatatableOptions.AJAX_DEFERRENDER, deferRender);
    }

    public void setDeferLoading(String deferLoading) {
        this.stagingOptions.put(DatatableOptions.AJAX_DEFERLOADING, deferLoading);
    }

    public void setFilterable(boolean filterable) {
        this.stagingOptions.put(DatatableOptions.FEATURE_FILTERABLE, filterable);
    }

    public void setInfo(boolean info) {
        this.stagingOptions.put(DatatableOptions.FEATURE_INFO, info);
    }

    public void setPageable(boolean pageable) {
        this.stagingOptions.put(DatatableOptions.FEATURE_PAGEABLE, pageable);
    }

    public void setLengthChange(boolean lengthChange) {
        this.stagingOptions.put(DatatableOptions.FEATURE_LENGTHCHANGE, lengthChange);
    }

    public void setProcessing(boolean processing) {
        this.stagingOptions.put(DatatableOptions.FEATURE_PROCESSING, processing);
    }

    public void setServerSide(boolean serverSide) {
        this.stagingOptions.put(DatatableOptions.AJAX_SERVERSIDE, serverSide);
    }

    public void setPagingType(String pagingType) {
        this.stagingOptions.put(DatatableOptions.FEATURE_PAGINGTYPE, pagingType);
    }

    public void setSortable(boolean sortable) {
        this.stagingOptions.put(DatatableOptions.FEATURE_SORTABLE, sortable);
    }

    public void setStateSave(String stateSave) {
        this.stagingOptions.put(DatatableOptions.FEATURE_STATESAVE, stateSave);
    }

    public void setScrollY(String scrollY) {
        this.stagingOptions.put(DatatableOptions.FEATURE_SCROLLY, scrollY);
    }

    public void setScrollCollapse(String scrollCollapse) {
        this.stagingOptions.put(DatatableOptions.FEATURE_SCROLLCOLLAPSE, scrollCollapse);
    }

    public void setScrollX(String scrollX) {
        this.stagingOptions.put(DatatableOptions.FEATURE_SCROLLX, scrollX);
    }

    public void setScrollXInner(String scrollXInner) {
        this.stagingOptions.put(DatatableOptions.FEATURE_SCROLLXINNER, scrollXInner);
    }

    public void setFixedPosition(String fixedPosition) {
        this.stagingOptions.put(DatatableOptions.PLUGIN_FIXEDPOSITION, fixedPosition);
    }

    public void setOffsetTop(int fixedOffsetTop) {
        this.stagingOptions.put(DatatableOptions.PLUGIN_FIXEDOFFSETTOP, fixedOffsetTop);
    }

    public void setExport(String export) {
        this.stagingOptions.put(DatatableOptions.EXPORT_ENABLED_FORMATS, export);
    }

    public void setExportStyle(String exportContainerStyle) {
        this.stagingOptions.put(DatatableOptions.EXPORT_CONTAINER_STYLE, exportContainerStyle);
    }

    public void setExportClass(String exportContainerClass) {
        this.stagingOptions.put(DatatableOptions.EXPORT_CONTAINER_CLASS, exportContainerClass);
    }

    public void setJqueryUI(String jqueryUI) {
        this.stagingOptions.put(DatatableOptions.FEATURE_JQUERYUI, jqueryUI);
    }

    public void setPipelining(String pipelining) {
        this.stagingOptions.put(DatatableOptions.AJAX_PIPELINING, pipelining);
    }

    public void setPipeSize(int pipeSize) {
        this.stagingOptions.put(DatatableOptions.AJAX_PIPESIZE, pipeSize);
    }

    public void setReloadSelector(String reloadSelector) {
        this.stagingOptions.put(DatatableOptions.AJAX_RELOAD_SELECTOR, reloadSelector);
    }

    public void setReloadFunction(String reloadFunction) {
        this.stagingOptions.put(DatatableOptions.AJAX_RELOAD_FUNCTION, reloadFunction);
    }

    public void setTheme(String theme) {
        System.out.println("theme=" + theme);
        this.stagingOptions.put(DatatableOptions.CSS_THEME, theme);
    }

    public void setThemeOption(String themeOption) {
        this.stagingOptions.put(DatatableOptions.CSS_THEMEOPTION, themeOption);
    }

    public void setLengthMenu(String lengthMenu) {
        this.stagingOptions.put(DatatableOptions.FEATURE_LENGTHMENU, lengthMenu);
    }

    public void setCssStripes(String cssStripesClasses) {
        this.stagingOptions.put(DatatableOptions.CSS_STRIPECLASSES, cssStripesClasses);
    }

    public void setAjaxParams(String ajaxParams) {
        this.stagingOptions.put(DatatableOptions.AJAX_PARAMS, ajaxParams);
    }

    public void setDisplayLength(int displayLength) {
        this.stagingOptions.put(DatatableOptions.FEATURE_DISPLAYLENGTH, displayLength);
    }

    public void setFilterDelay(int filterDelay) {
        this.stagingOptions.put(DatatableOptions.FEATURE_FILTER_DELAY, filterDelay);
    }

    public void setFilterSelector(String filterSelector) {
        this.stagingOptions.put(DatatableOptions.FEATURE_FILTER_SELECTOR, filterSelector);
    }

    public void setFilterClearSelector(String filterClearSelector) {
        this.stagingOptions.put(DatatableOptions.FEATURE_FILTER_CLEAR_SELECTOR, filterClearSelector);
    }

    public void setDom(String dom) {
        this.stagingOptions.put(DatatableOptions.FEATURE_DOM, dom);
    }

    public void setExt(String extensions) {
        this.stagingOptions.put(DatatableOptions.MAIN_EXTENSION_NAMES, extensions);
    }

    public void setCssStyle(String cssStyle) {
        this.stagingOptions.put(DatatableOptions.CSS_STYLE, cssStyle);
    }

    public void setCssClass(String cssClass) {
        this.stagingOptions.put(DatatableOptions.CSS_CLASS, cssClass);
    }

    public void setFilterPlaceholder(String filterPlaceholder) {
        this.stagingOptions.put(DatatableOptions.FEATURE_FILTER_PLACEHOLDER, filterPlaceholder);
    }
}

