/*
 * Decompiled with CFR 0.152.
 */
package com.github.daniel.shuy.kafka.protobuf.serde;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaProtobufDeserializer<T extends MessageLite>
implements Deserializer<T> {
    private final Parser<T> parser;

    public KafkaProtobufDeserializer(Parser<T> parser) {
        this.parser = parser;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)((MessageLite)this.parser.parseFrom(data));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("Error deserializing from Protobuf message", (Throwable)e);
        }
    }

    public void close() {
    }
}

