/**
 * Copyright (C) 2011 Daniel Bell <daniel.r.bell@gmail.com>
 *
 * This file is part of Smallprox.
 *
 * Smallprox is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Smallprox is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Smallprox.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.github.danielbell.smallprox;

import javax.lang.model.element.*;
import javax.lang.model.util.AbstractElementVisitor6;

/**
 * An element visitor that executes a {@link #defaultAction default action} for
 * each element. The default default action is to visit all enclosed elements.
 */
class ElementVisitorAdapter<R, P> extends AbstractElementVisitor6<R, P> {

    @Override
    public R visitPackage(PackageElement element, P parameter) {
        return defaultAction(element, parameter);
    }

    @Override
    public R visitType(TypeElement element, P parameter) {
        return defaultAction(element, parameter);
    }

    @Override
    public R visitVariable(VariableElement element, P parameter) {
        return defaultAction(element, parameter);
    }

    @Override
    public R visitExecutable(ExecutableElement element, P parameter) {
        return defaultAction(element, parameter);
    }

    @Override
    public R visitTypeParameter(TypeParameterElement element, P parameter) {
        return defaultAction(element, parameter);
    }

    protected R defaultAction(Element e, P parameter) {
        R result = null;
        for (Element child : e.getEnclosedElements()) {
            result = child.accept(this, parameter);
        }
        return result;
    }
}
