/**
 * Copyright (C) 2011 Daniel Bell <daniel.r.bell@gmail.com>
 *
 * This file is part of Smallprox.
 *
 * Smallprox is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Smallprox is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Smallprox.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.github.danielbell.smallprox;

import java.beans.Introspector;

/**
 * Helps to find out information about JavaBean-style methods
 */
class JavaBeanMethod {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final String GETTER_PREFIX_REGEX = String.format("(%s|%s)", GET, IS);

    static JavaBeanMethod named(String name) {
        return new JavaBeanMethod(name);
    }
    private final String name;

    private JavaBeanMethod(String name) {
        this.name = name;
    }

    public boolean isGetter() {
        return name.startsWith(GET) || name.startsWith(IS);
    }

    public boolean isSetter() {
        return name.startsWith(SET);
    }

    public String getFieldName() {
        String prefixless;
        if (isGetter()) {
            prefixless = name.replaceFirst(GETTER_PREFIX_REGEX, "");
        } else {
            prefixless = name.replaceFirst(SET, "");
        }
        //TODO: this will leave HTML and URL alone. Is that what we want?
        return Introspector.decapitalize(prefixless);
    }

    public boolean isValidJavaBeanMethod() {
        return isGetter() || isSetter();
    }
}
