/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import com.github.danielbell.smallprox.OutputPackageProvider;
import com.github.danielbell.smallprox.Proxiable;
import com.github.danielbell.smallprox.ProxyFactory;
import com.github.danielbell.smallprox.SimpleOutputPackageProvider;
import com.sun.codemodel.ClassWriter;
import com.sun.codemodel.JDefinedClass;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

class Generator {
    private static final Logger LOGGER = Logger.getLogger("Smallprox");
    private final ProcessingEnvironment env;
    private final ProxyFactory proxyFactory;
    private OutputPackageProvider outputPackageProvider;

    public Generator(ProcessingEnvironment env, Map<String, Proxiable> proxiables) {
        this.env = env;
        if (env.getOptions().containsKey("smallprox.outputPackageProvider")) {
            String packageProviderName = env.getOptions().get("smallprox.outputPackageProvider");
            LOGGER.log(Level.INFO, "OutputPackageProvider specified: {0}", packageProviderName);
            try {
                this.outputPackageProvider = (OutputPackageProvider)Class.forName(packageProviderName).newInstance();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Couldn't instantiate OutputPackageProvider " + packageProviderName, ex);
                throw new RuntimeException(ex);
            }
        } else {
            this.outputPackageProvider = new SimpleOutputPackageProvider();
        }
        this.proxyFactory = new ProxyFactory(this.outputPackageProvider, proxiables);
    }

    public void generate(Proxiable entity) throws IOException {
        JDefinedClass proxyClass = this.proxyFactory.createProxy(entity);
        JavaFileObject file = this.createSourceFile(proxyClass, entity);
        this.write(proxyClass, file);
    }

    private JavaFileObject createSourceFile(JDefinedClass proxyClass, Proxiable entity) throws IOException {
        PackageElement packageElement = (PackageElement)entity.getElement().getEnclosingElement();
        String packageName = this.outputPackageProvider.outputPackageFor(packageElement.getQualifiedName().toString());
        String className = packageName + "." + proxyClass.name();
        return this.env.getFiler().createSourceFile(className, entity.getElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(JDefinedClass proxyClass, FileObject destination) throws IOException {
        ClassWriter classWriter = new ClassWriter(destination.openWriter());
        try {
            classWriter.write(proxyClass);
        }
        finally {
            classWriter.close();
        }
    }
}

