/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import java.beans.Introspector;

class JavaBeanMethod {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final String GETTER_PREFIX_REGEX = String.format("(%s|%s)", "get", "is");
    private final String name;

    static JavaBeanMethod named(String name) {
        return new JavaBeanMethod(name);
    }

    private JavaBeanMethod(String name) {
        this.name = name;
    }

    public boolean isGetter() {
        return this.name.startsWith(GET) || this.name.startsWith(IS);
    }

    public boolean isSetter() {
        return this.name.startsWith(SET);
    }

    public String getFieldName() {
        String prefixless = this.isGetter() ? this.name.replaceFirst(GETTER_PREFIX_REGEX, "") : this.name.replaceFirst(SET, "");
        return Introspector.decapitalize(prefixless);
    }

    public boolean isValidJavaBeanMethod() {
        return this.isGetter() || this.isSetter();
    }
}

