/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class MessagerAppender
extends Handler {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();
    private final Messager messager;

    static MessagerAppender forEnvironment(ProcessingEnvironment env) {
        return new MessagerAppender(env);
    }

    private MessagerAppender(ProcessingEnvironment env) {
        this.messager = env.getMessager();
    }

    @Override
    public void publish(LogRecord record) {
        Diagnostic.Kind messageKind = this.kindOfMessage(record);
        if (messageKind != null) {
            Object[] parameters = record.getParameters();
            String messageTemplate = record.getMessage();
            if (parameters == null || parameters.length == 0) {
                this.messager.printMessage(messageKind, messageTemplate);
            } else if (parameters[parameters.length - 1] instanceof Element) {
                Element element = (Element)parameters[parameters.length - 1];
                if (parameters.length == 1) {
                    this.messager.printMessage(messageKind, messageTemplate, element);
                } else {
                    Object[] otherParams = Arrays.copyOfRange(parameters, 0, parameters.length - 1);
                    record.setParameters(otherParams);
                    String message = FORMATTER.formatMessage(record);
                    this.messager.printMessage(messageKind, message, element);
                }
            } else {
                String message = FORMATTER.formatMessage(record);
                this.messager.printMessage(messageKind, message);
            }
            if (record.getThrown() != null) {
                Throwable error = record.getThrown();
                this.messager.printMessage(Diagnostic.Kind.ERROR, error.toString());
                for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                    this.messager.printMessage(Diagnostic.Kind.NOTE, stackTraceElement.toString());
                }
            }
        }
    }

    private Diagnostic.Kind kindOfMessage(LogRecord record) {
        Level level = record.getLevel();
        if (this.atLeast(level, Level.SEVERE)) {
            return Diagnostic.Kind.ERROR;
        }
        if (this.atLeast(level, Level.WARNING)) {
            return Diagnostic.Kind.MANDATORY_WARNING;
        }
        if (this.atLeast(level, Level.INFO)) {
            return Diagnostic.Kind.NOTE;
        }
        return null;
    }

    private boolean atLeast(Level a, Level b) {
        return a.intValue() >= b.intValue();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

