/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;

class Proxiable {
    private final String className;
    private final List<Method> methods = new LinkedList<Method>();
    private Proxiable parent;
    private final TypeElement element;

    public Proxiable(TypeElement e) {
        this.element = e;
        this.className = e.getQualifiedName().toString();
    }

    public TypeElement getElement() {
        return this.element;
    }

    public boolean isEntity() {
        return this.element.getAnnotation(Entity.class) != null || this.element.getAnnotation(MappedSuperclass.class) != null;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Method> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public Proxiable getParent() {
        return this.parent;
    }

    public void setParent(Proxiable parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Proxiable other = (Proxiable)obj;
        return !(this.className != null ? !this.className.equals(other.className) : other.className != null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.className != null ? this.className.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return String.format("Proxiable[%s]", this.className);
    }

    public static class Type {
        private final String name;
        private final List<Type> parameters = new LinkedList<Type>();

        public Type(String name, Type ... parameters) {
            this.name = name;
            this.parameters.addAll(Arrays.asList(parameters));
        }

        public String getName() {
            return this.name;
        }

        public List<Type> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public void addParameter(Type parameter) {
            this.parameters.add(parameter);
        }
    }

    public static class Method {
        private String name;
        private Type returnType;
        private final List<Parameter> parameters;

        public static Builder named(String methodName) {
            return new Builder(methodName);
        }

        public Method(String name, Type returnType, List<Parameter> parameters) {
            this.name = name;
            this.returnType = returnType;
            this.parameters = new ArrayList<Parameter>(parameters);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Type returnType) {
            this.returnType = returnType;
        }

        public List<Parameter> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public static class Parameter {
            private final Type type;
            private final String name;

            public Parameter(Type type, String name) {
                this.type = type;
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public Type getType() {
                return this.type;
            }
        }

        public static class Builder {
            private final String name;
            private final List<Parameter> params = new LinkedList<Parameter>();
            private Type returnType;

            private Builder(String name) {
                this.name = name;
            }

            public Builder returning(Type returnType) {
                this.returnType = returnType;
                return this;
            }

            public Builder addParam(Type type, String name) {
                this.params.add(new Parameter(type, name));
                return this;
            }

            public Method build() {
                assert (this.name != null && this.returnType != null);
                return new Method(this.name, this.returnType, this.params);
            }
        }
    }
}

