/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import com.github.danielbell.smallprox.ElementVisitorAdapter;
import com.github.danielbell.smallprox.JavaBeanMethod;
import com.github.danielbell.smallprox.Proxiable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.tools.Diagnostic;

class ProxiableVisitor
extends ElementVisitorAdapter<Void, Proxiable> {
    private final Map<String, Proxiable> proxiables = new HashMap<String, Proxiable>();
    private final ProcessingEnvironment env;

    public ProxiableVisitor(ProcessingEnvironment env) {
        this.env = env;
    }

    public Map<String, Proxiable> getProxiables() {
        return Collections.unmodifiableMap(this.proxiables);
    }

    @Override
    public Void visitType(TypeElement typeElement, Proxiable child) {
        boolean isOrSuperclassesEntity;
        boolean hasProxiableChild = child != null;
        boolean bl = isOrSuperclassesEntity = this.isEntityOrEmbeddable(typeElement) || hasProxiableChild;
        if (isOrSuperclassesEntity && this.isProxiable(typeElement)) {
            Proxiable proxiable = new Proxiable(typeElement);
            this.proxiables.put(proxiable.getClassName(), proxiable);
            if (hasProxiableChild) {
                child.setParent(proxiable);
            }
            for (Element element : typeElement.getEnclosedElements()) {
                element.accept(this, proxiable);
            }
            Element superclass = this.asElement(typeElement.getSuperclass());
            superclass.accept(this, proxiable);
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement element, Proxiable enclosingEntity) {
        if (ProxiableVisitor.isNonstaticMethod(element)) {
            if (this.refersToTransientProperty(enclosingEntity.getElement(), element)) {
                return null;
            }
            String methodName = element.getSimpleName().toString();
            TypeMirror returnTypeMirror = element.getReturnType();
            Proxiable.Type returnType = this.asProxiableType(returnTypeMirror);
            Proxiable.Method.Builder method = Proxiable.Method.named(methodName).returning(returnType);
            List<? extends VariableElement> parameterElements = element.getParameters();
            for (VariableElement variableElement : parameterElements) {
                TypeMirror paramTypeMirror = variableElement.asType();
                Proxiable.Type paramType = this.asProxiableType(paramTypeMirror);
                String paramName = variableElement.getSimpleName().toString();
                method.addParam(paramType, paramName);
            }
            enclosingEntity.addMethod(method.build());
        }
        return null;
    }

    private static boolean isNonstaticMethod(ExecutableElement element) {
        return element.getKind() == ElementKind.METHOD && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private Proxiable.Type asProxiableType(TypeMirror typeMirror) {
        String typeName = this.getTypeName(typeMirror);
        Proxiable.Type type = new Proxiable.Type(typeName, new Proxiable.Type[0]);
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declared = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = declared.getTypeArguments();
            for (TypeMirror typeMirror2 : typeArguments) {
                Proxiable.Type arg = this.asProxiableType(typeMirror2);
                type.addParameter(arg);
            }
        }
        return type;
    }

    private void log(String message, Element e) {
        this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, message, e);
    }

    private boolean isProxiable(TypeElement element) {
        boolean isNull = element == null;
        boolean isObject = element.getSuperclass().getKind() == TypeKind.NONE;
        return !isNull && !isObject;
    }

    private Element asElement(TypeMirror typeMirror) {
        return this.env.getTypeUtils().asElement(typeMirror);
    }

    private boolean isEntityOrEmbeddable(TypeElement typeElement) {
        return typeElement.getAnnotation(Entity.class) != null || typeElement.getAnnotation(Embeddable.class) != null;
    }

    private String getTypeName(TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            Name binaryName = this.env.getElementUtils().getBinaryName(typeElement);
            return binaryName.toString();
        }
        return ((Object)returnType).toString();
    }

    private boolean refersToTransientProperty(TypeElement enclosingElement, ExecutableElement methodElement) {
        if (methodElement.getAnnotation(Transient.class) != null) {
            return true;
        }
        String methodName = methodElement.getSimpleName().toString();
        JavaBeanMethod beanMethod = JavaBeanMethod.named(methodName);
        if (beanMethod.isValidJavaBeanMethod()) {
            Element field = this.getField(enclosingElement, beanMethod.getFieldName());
            if (field != null && field.getAnnotation(Transient.class) != null) {
                return true;
            }
            if (beanMethod.isSetter()) {
                String fieldName = beanMethod.getFieldName();
                String getterName = "get" + Character.valueOf(fieldName.charAt(0)).toString().toUpperCase() + fieldName.substring(1);
                List<? extends Element> enclosedElements = enclosingElement.getEnclosedElements();
                for (Element element : enclosedElements) {
                    if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().toString().equals(getterName)) continue;
                    return element.getAnnotation(Transient.class) != null;
                }
            }
        }
        return false;
    }

    private Element getField(TypeElement type, String fieldName) {
        for (Element element : type.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().toString().equals(fieldName)) continue;
            return element;
        }
        return null;
    }
}

