/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import com.github.danielbell.smallprox.OutputPackageProvider;
import com.github.danielbell.smallprox.Proxiable;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.PackageElement;

class ProxyFactory {
    private static final List<String> PRIMITIVES = Arrays.asList(Void.TYPE.getName(), Character.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), String.class.getName(), List.class.getName(), Set.class.getName(), Map.class.getName());
    private static final String PROXY_SUFFIX = "Proxy";
    private static final Logger LOGGER = Logger.getLogger("Smallprox");
    private final OutputPackageProvider outputPackageProvider;
    private final Map<String, Proxiable> proxiables;

    ProxyFactory(OutputPackageProvider outputPackageProvider, Map<String, Proxiable> proxiables) {
        this.outputPackageProvider = outputPackageProvider;
        this.proxiables = proxiables;
    }

    public JDefinedClass createProxy(Proxiable proxiable) {
        try {
            String proxyFqn = this.getProxifiedName(proxiable);
            JCodeModel cm = new JCodeModel();
            JDefinedClass proxyClass = cm._class(proxyFqn, ClassType.INTERFACE);
            JClass proxyAnnotationType = cm.ref("com.google.web.bindery.requestfactory.shared.ProxyFor");
            JClass proxiableType = cm.ref(proxiable.getClassName());
            JAnnotationUse proxyAnnotation = proxyClass.annotate(proxyAnnotationType);
            proxyAnnotation.param("value", (JType)proxiableType);
            Proxiable parent = proxiable.getParent();
            Object parentClass = parent == null ? (proxiable.isEntity() ? cm.ref("com.google.web.bindery.requestfactory.shared.EntityProxy") : cm.ref("com.google.web.bindery.requestfactory.shared.ValueProxy")) : cm._class(this.getProxifiedName(parent), ClassType.INTERFACE);
            proxyClass._extends(parentClass);
            for (Proxiable.Method method : proxiable.getMethods()) {
                String methodName = method.getName();
                Proxiable.Type sourceReturnType = method.getReturnType();
                JClass returnType = this.asGenericCodeModelType(sourceReturnType, cm);
                JMethod proxyMethod = proxyClass.method(0, (JType)returnType, methodName);
                for (Proxiable.Method.Parameter parameter : method.getParameters()) {
                    Proxiable.Type sourceParamType = parameter.getType();
                    JClass paramType = this.asGenericCodeModelType(sourceParamType, cm);
                    String paramName = parameter.getName();
                    proxyMethod.param((JType)paramType, paramName);
                }
            }
            return proxyClass;
        }
        catch (JClassAlreadyExistsException ex) {
            LOGGER.log(Level.WARNING, "Tried to create a class that was already created: {0}", new Object[]{ex.getMessage(), proxiable.getElement()});
            throw new AssertionError((Object)ex);
        }
    }

    private JClass asGenericCodeModelType(Proxiable.Type type, JCodeModel cm) {
        String typeName = this.getMaybeProxyName(type.getName());
        JClass codeModelType = cm.ref(typeName);
        List<Proxiable.Type> typeParams = type.getParameters();
        for (Proxiable.Type typeArgument : typeParams) {
            JClass typeArg = this.asGenericCodeModelType(typeArgument, cm);
            codeModelType = codeModelType.narrow(typeArg);
        }
        return codeModelType;
    }

    private String getMaybeProxyName(String fqn) {
        if (!PRIMITIVES.contains(fqn) && this.proxiables.containsKey(fqn)) {
            return this.getProxifiedName(fqn);
        }
        return fqn;
    }

    private String getProxifiedName(Proxiable entity) {
        String inputPackageName = ((PackageElement)entity.getElement().getEnclosingElement()).getQualifiedName().toString();
        String simpleName = entity.getElement().getSimpleName().toString();
        return this.getProxifiedName(inputPackageName, simpleName);
    }

    private String getProxifiedName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return className + PROXY_SUFFIX;
        }
        String packageName = className.substring(0, lastDotIndex);
        String simpleName = className.substring(lastDotIndex + 1);
        return this.getProxifiedName(packageName, simpleName);
    }

    private String getProxifiedName(String inputPackageName, String simpleName) {
        String outputPackageName = this.outputPackageProvider.outputPackageFor(inputPackageName);
        return outputPackageName + "." + simpleName + PROXY_SUFFIX;
    }
}

