/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielbell.smallprox;

import com.github.danielbell.smallprox.Generator;
import com.github.danielbell.smallprox.MessagerAppender;
import com.github.danielbell.smallprox.Proxiable;
import com.github.danielbell.smallprox.ProxiableVisitor;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.Embeddable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"smallprox.outputPackageProvider"})
public class SmallproxProcessor
extends AbstractProcessor {
    public static final String LOGGER_NAME = "Smallprox";
    private static final Logger LOGGER = Logger.getLogger("Smallprox");
    private static final String OPTION_PREFIX = "smallprox.";
    static final String OPTION_ENTITY_OUTPUT_PACKAGE_PROVIDER = "smallprox.outputPackageProvider";
    private static final boolean CLAIM_ANNOTATIONS = false;
    private ProcessingEnvironment env;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.env = processingEnv;
        LOGGER.addHandler(MessagerAppender.forEnvironment(this.env));
        LOGGER.info("Initialising GWT RequestFactory proxy generator...");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, Proxiable> entities = this.getProxiables(roundEnv);
        this.generateProxySources(entities);
        return false;
    }

    private Map<String, Proxiable> getProxiables(RoundEnvironment roundEnv) {
        ProxiableVisitor entityVisitor = new ProxiableVisitor(this.env);
        Set<? extends Element> rootElements = roundEnv.getRootElements();
        for (Element element : rootElements) {
            element.accept(entityVisitor, null);
        }
        return entityVisitor.getProxiables();
    }

    private void generateProxySources(Map<String, Proxiable> proxiables) {
        Generator generator = new Generator(this.env, proxiables);
        for (Proxiable proxiable : proxiables.values()) {
            LOGGER.log(Level.INFO, "Generating GWT RequestFactory proxy for JPA type: {0}", new Object[]{proxiable, proxiable.getElement()});
            try {
                generator.generate(proxiable);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Could not create GWT RequestFactory proxy for source file: {0}", new Object[]{ex.getMessage(), proxiable.getElement()});
            }
        }
    }
}

