/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class BugzillaIssueLinkConverter
implements MessageConverter {
    private Pattern pattern;
    private final Log log;
    private final String urlPrefix;
    private final String urlSufix = "/show_bug.cgi?id=";

    public BugzillaIssueLinkConverter(Log log, String urlPrefix, String bugzillaPattern) {
        this.log = log;
        urlPrefix = urlPrefix.endsWith("/") ? urlPrefix.substring(0, urlPrefix.length() - 1) : urlPrefix;
        this.urlPrefix = !urlPrefix.endsWith("/show_bug.cgi?id=") ? urlPrefix + "/show_bug.cgi?id=" : urlPrefix;
        this.pattern = Pattern.compile(bugzillaPattern, 2);
    }

    @Override
    public String formatCommitMessage(String original) {
        try {
            Matcher matcher = this.pattern.matcher(original);
            String result = matcher.replaceAll("<a href=\"" + this.urlPrefix + "$1\">Bug $1</a>");
            return result;
        }
        catch (Exception e) {
            this.log.info((CharSequence)("Unable to parse issue tracking URL in commit message: " + original), (Throwable)e);
            return original;
        }
    }
}

