/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog;

import com.github.danielflower.mavenplugins.gitlog.Defaults;
import com.github.danielflower.mavenplugins.gitlog.Generator;
import com.github.danielflower.mavenplugins.gitlog.NoGitRepositoryException;
import com.github.danielflower.mavenplugins.gitlog.filters.CommitFilter;
import com.github.danielflower.mavenplugins.gitlog.filters.CommiterFilter;
import com.github.danielflower.mavenplugins.gitlog.filters.MergeCommitFilter;
import com.github.danielflower.mavenplugins.gitlog.filters.PathCommitFilter;
import com.github.danielflower.mavenplugins.gitlog.filters.RegexpFilter;
import com.github.danielflower.mavenplugins.gitlog.renderers.AsciidocReleaseNotesRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.AsciidocRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.BugzillaIssueLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import com.github.danielflower.mavenplugins.gitlog.renderers.GitHubIssueLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.JiraIssueLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.JsonRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.MarkdownRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.MavenLoggerRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.NullMessageConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.PlainTextRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.SimpleHtmlRenderer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.lib.Repository;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="project.build.directory")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.name} v${project.version} git changelog")
    private String reportTitle;
    @Parameter(defaultValue="true")
    private boolean generatePlainTextChangeLog;
    @Parameter(defaultValue="changelog.txt")
    private String plainTextChangeLogFilename;
    @Parameter(defaultValue="false")
    private boolean generateMarkdownChangeLog;
    @Parameter(defaultValue="false")
    private boolean generateAsciidocChangeLog;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean generatAsciidocChangeLog;
    @Parameter(defaultValue="false")
    private boolean generateAsciidocReleaseNotes;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean generatAsciidocReleaseNotes;
    @Parameter(defaultValue="changelog.md")
    private String markdownChangeLogFilename;
    @Parameter(defaultValue="false")
    private boolean markdownChangeLogAppend;
    @Parameter(defaultValue="changelog.adoc")
    private String asciidocChangeLogFilename;
    @Parameter(defaultValue="releaseNotes.adoc")
    private String asciidocReleaseNotesFilename;
    @Parameter(defaultValue="true")
    private boolean generateSimpleHTMLChangeLog;
    @Parameter(defaultValue="changelog.html")
    private String simpleHTMLChangeLogFilename;
    @Parameter(defaultValue="false")
    private boolean generateHTMLTableOnlyChangeLog;
    @Parameter(defaultValue="changelogtable.html")
    private String htmlTableOnlyChangeLogFilename;
    @Parameter(defaultValue="true")
    private boolean generateJSONChangeLog;
    @Parameter(defaultValue="changelog.json")
    private String jsonChangeLogFilename;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(property="project.issueManagement.system")
    private String issueManagementSystem;
    @Parameter(property="project.issueManagement.url")
    private String issueManagementUrl;
    @Parameter(defaultValue="Bug (\\d+)")
    private String bugzillaPattern;
    @Parameter(defaultValue="yyyy-MM-dd HH:mm:ss Z")
    private String dateFormat;
    @Parameter(defaultValue="true")
    private boolean showCommiter;
    @Parameter(defaultValue="1970-01-01 00:00:00.0 AM")
    private Date includeCommitsAfter;
    @Parameter(defaultValue="")
    private String includeCommitsAfterCommit;
    @Parameter
    private List<String> excludeCommiters;
    @Parameter(defaultValue="false")
    private boolean fullGitMessage;
    @Parameter(defaultValue="false")
    private boolean fullGitMessageReleaseNotes;
    @Parameter
    private String excludeCommitsPattern;
    @Parameter
    private String path;
    @Parameter(defaultValue="true")
    private boolean mergeCommitFilter;
    @Parameter(defaultValue="=")
    private String asciidocHeading;
    @Parameter(defaultValue="false")
    private boolean asciidocTableView;
    @Parameter(defaultValue="Date")
    private String asciidocTableViewHeader1;
    @Parameter(defaultValue="Commit")
    private String asciidocTableViewHeader2;
    @Parameter(defaultValue="true")
    private boolean mergeCommitFilterReleaseNotes;
    @Parameter(defaultValue="=")
    private String asciidocHeadingReleaseNotes;
    @Parameter(defaultValue="false")
    private boolean asciidocTableViewReleaseNotes;
    @Parameter(defaultValue="Date")
    private String asciidocTableViewHeader1ReleaseNotes;
    @Parameter(defaultValue="Merge")
    private String asciidocTableViewHeader2ReleaseNotes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Repository repository;
        List<ChangeLogRenderer> renderers;
        this.getLog().info((CharSequence)("Generating gitlog in " + this.outputDirectory.getAbsolutePath() + " with title " + this.reportTitle));
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            renderers = this.createRenderers();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error while setting up gitlog renderers.  No changelog will be generated.", (Throwable)e);
            return;
        }
        ArrayList<CommitFilter> commitFilters = new ArrayList<CommitFilter>(Defaults.COMMIT_FILTERS);
        if (this.mergeCommitFilter) {
            commitFilters.add(new MergeCommitFilter());
        }
        if (this.mergeCommitFilterReleaseNotes) {
            commitFilters.add(new MergeCommitFilter());
        }
        if (this.excludeCommiters != null && !this.excludeCommiters.isEmpty()) {
            commitFilters.add(new CommiterFilter(this.excludeCommiters));
        }
        if (this.excludeCommitsPattern != null) {
            commitFilters.add(new RegexpFilter(this.excludeCommitsPattern));
        }
        Generator generator = new Generator(renderers, commitFilters, this.getLog());
        try {
            repository = generator.openRepository();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error opening git repository.  Is this Maven project hosted in a git repository? No changelog will be generated.", (Throwable)e);
            return;
        }
        catch (NoGitRepositoryException e) {
            this.getLog().warn((CharSequence)"This maven project does not appear to be in a git repository, therefore no git changelog will be generated.");
            return;
        }
        if (this.path != null) {
            commitFilters.add(new PathCommitFilter(repository, this.path, this.getLog()));
        }
        if (!"".equals(this.dateFormat)) {
            Formatter.setFormat(this.dateFormat, this.getLog());
        }
        Formatter.setCommiter(this.showCommiter, this.getLog());
        try {
            generator.generate(this.reportTitle, this.includeCommitsAfter, this.includeCommitsAfterCommit);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error while generating gitlog.  Some changelogs may be incomplete or corrupt.", (Throwable)e);
        }
    }

    private List<ChangeLogRenderer> createRenderers() throws IOException {
        ArrayList<ChangeLogRenderer> renderers = new ArrayList<ChangeLogRenderer>();
        if (this.generatePlainTextChangeLog) {
            renderers.add(new PlainTextRenderer(this.getLog(), this.outputDirectory, this.plainTextChangeLogFilename, this.fullGitMessage));
        }
        if (this.generateSimpleHTMLChangeLog || this.generateHTMLTableOnlyChangeLog || this.generateMarkdownChangeLog || this.generateAsciidocChangeLog || this.generatAsciidocChangeLog || this.generateAsciidocReleaseNotes || this.generatAsciidocReleaseNotes) {
            MessageConverter messageConverter = this.getCommitMessageConverter();
            if (this.generateSimpleHTMLChangeLog) {
                renderers.add(new SimpleHtmlRenderer(this.getLog(), this.outputDirectory, this.simpleHTMLChangeLogFilename, this.fullGitMessage, messageConverter, false));
            }
            if (this.generateHTMLTableOnlyChangeLog) {
                renderers.add(new SimpleHtmlRenderer(this.getLog(), this.outputDirectory, this.htmlTableOnlyChangeLogFilename, this.fullGitMessage, messageConverter, true));
            }
            if (this.generateMarkdownChangeLog) {
                renderers.add(new MarkdownRenderer(this.getLog(), this.outputDirectory, this.markdownChangeLogFilename, this.fullGitMessage, messageConverter, this.markdownChangeLogAppend));
            }
            if (this.generateAsciidocChangeLog || this.generatAsciidocChangeLog) {
                renderers.add(new AsciidocRenderer(this.getLog(), this.outputDirectory, this.asciidocChangeLogFilename, this.fullGitMessage, messageConverter, this.asciidocHeading, this.asciidocTableView, this.asciidocTableViewHeader1, this.asciidocTableViewHeader2));
            }
            if (this.generateAsciidocReleaseNotes || this.generatAsciidocReleaseNotes) {
                renderers.add(new AsciidocReleaseNotesRenderer(this.getLog(), this.outputDirectory, this.asciidocReleaseNotesFilename, this.fullGitMessageReleaseNotes, messageConverter, this.asciidocHeadingReleaseNotes, this.asciidocTableViewReleaseNotes, this.asciidocTableViewHeader1ReleaseNotes, this.asciidocTableViewHeader2ReleaseNotes));
            }
        }
        if (this.generateJSONChangeLog) {
            renderers.add(new JsonRenderer(this.getLog(), this.outputDirectory, this.jsonChangeLogFilename, this.fullGitMessage));
        }
        if (this.verbose) {
            renderers.add(new MavenLoggerRenderer(this.getLog()));
        }
        return renderers;
    }

    private MessageConverter getCommitMessageConverter() {
        this.getLog().debug((CharSequence)("Trying to load issue tracking info: " + this.issueManagementSystem + " / " + this.issueManagementUrl));
        MessageConverter converter = null;
        try {
            if (this.issueManagementUrl != null && this.issueManagementUrl.contains("://")) {
                String system = ("" + this.issueManagementSystem).toLowerCase();
                if (system.toLowerCase().contains("jira")) {
                    converter = new JiraIssueLinkConverter(this.getLog(), this.issueManagementUrl);
                } else if (system.toLowerCase().contains("github")) {
                    converter = new GitHubIssueLinkConverter(this.getLog(), this.issueManagementUrl);
                } else if (system.toLowerCase().contains("bugzilla")) {
                    converter = new BugzillaIssueLinkConverter(this.getLog(), this.issueManagementUrl, this.bugzillaPattern);
                }
            }
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Could not load issue management system information; no HTML links will be generated.", (Throwable)ex);
        }
        if (converter == null) {
            converter = new NullMessageConverter();
        }
        this.getLog().debug((CharSequence)("Using tracker " + converter.getClass().getSimpleName()));
        return converter;
    }
}

