/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class JiraIssueLinkConverter
implements MessageConverter {
    private Pattern pattern;
    private final Log log;
    private final String urlPrefix;

    public JiraIssueLinkConverter(Log log, String urlPrefix, String jiraPattern) {
        this.log = log;
        urlPrefix = urlPrefix.endsWith("/") ? urlPrefix.substring(0, urlPrefix.length() - 2) : urlPrefix;
        this.urlPrefix = urlPrefix.substring(0, urlPrefix.lastIndexOf("/") + 1);
        this.pattern = Pattern.compile(jiraPattern);
    }

    @Override
    public String formatCommitMessage(String original) {
        try {
            Matcher matcher = this.pattern.matcher(original);
            String result = matcher.replaceAll("<a href=\"" + this.urlPrefix + "$0\">$0</a>");
            return result;
        }
        catch (Exception e) {
            this.log.info((CharSequence)("Unable to parse issue tracking URL in commit message: " + original), (Throwable)e);
            return original;
        }
    }
}

