/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;

public abstract class FileRenderer
implements ChangeLogRenderer {
    protected Writer writer;
    protected final Log log;

    public FileRenderer(Log log, File targetFolder, String filename) throws IOException {
        this.log = log;
        File file = new File(targetFolder, filename);
        log.debug((CharSequence)("Creating git changelog at " + file.getAbsolutePath()));
        this.writer = new FileWriter(file);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                this.log.error((CharSequence)"Could not flush file to disk", (Throwable)e);
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

