/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class GitHubIssueLinkConverter
implements MessageConverter {
    private Pattern pattern;
    private final Log log;
    private final String urlPrefix;

    public GitHubIssueLinkConverter(Log log, String urlPrefix) {
        this.log = log;
        this.urlPrefix = urlPrefix.endsWith("/") ? urlPrefix : urlPrefix + "/";
        this.pattern = Pattern.compile("(GH-|#)([0-9]+)", 2);
    }

    @Override
    public String formatCommitMessage(String original) {
        try {
            Matcher matcher = this.pattern.matcher(original);
            String result = matcher.replaceAll("<a href=\"" + this.urlPrefix + "$2\">$0</a>");
            return result;
        }
        catch (Exception e) {
            this.log.info((CharSequence)("Unable to parse issue tracking URL in commit message: " + original), (Throwable)e);
            return original;
        }
    }

    private String getNumberFrom(String input) {
        return Pattern.compile("[^0-9]").matcher(input).replaceAll("");
    }
}

