package com.github.danielflower.mavenplugins.gitlog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-gitlog-plugin.<br/> Call <pre>  mvn gitlog:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Apr 10 22:02:43 CST 2014
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "com.github.danielflower.mavenplugins:maven-gitlog-plugin:1.6.0", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Git Log Plugin", 0 );
        append( sb, "Generates a changelog based on commits to a git repository in text and HTML format showing the changes that are included in each version. A possible use of this is to include these changelogs when packaging your maven project so that you have an accurate list of commits that the current package includes.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "generate".equals( goal ) )
        {
            append( sb, "gitlog:generate", 0 );
            append( sb, "Goal which generates a changelog based on commits made to the current git repo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dateFormat", 2 );
                append( sb, "Used to set date format in log messages. If unspecified, will be used default format \'yyyy-MM-dd HH:mm:ss Z\'.", 3 );
                append( sb, "", 0 );

                append( sb, "fullGitMessage (Default: false)", 2 );
                append( sb, "If true, the changelog will include the full git message rather that the short git message", 3 );
                append( sb, "", 0 );

                append( sb, "generateHTMLTableOnlyChangeLog (Default: false)", 2 );
                append( sb, "If true, then an HTML changelog which contains only a table element will be generated. This incomplete HTML page is suitable for inclusion in other webpages, for example you may want to embed it in a wiki page.", 3 );
                append( sb, "", 0 );

                append( sb, "generateMarkdownChangeLog (Default: false)", 2 );
                append( sb, "If true, then a markdown changelog will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "generatePlainTextChangeLog (Default: true)", 2 );
                append( sb, "If true, then a plain text changelog will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "generateSimpleHTMLChangeLog (Default: true)", 2 );
                append( sb, "If true, then a simple HTML changelog will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlTableOnlyChangeLogFilename (Default: changelogtable.html)", 2 );
                append( sb, "The filename of the HTML table changelog, if generated.", 3 );
                append( sb, "", 0 );

                append( sb, "includeCommitsAfter (Default: 1970-01-01 00:00:00.0 AM)", 2 );
                append( sb, "Include in the changelog the commits after this parameter value.", 3 );
                append( sb, "", 0 );

                append( sb, "issueManagementSystem", 2 );
                append( sb, "Used to create links to your issue tracking system for HTML reports. If unspecified, it will try to use the value specified in the issueManagement section of your project\'s POM. The following values are supported: a value containing the string \'github\' for the GitHub Issue tracking software; a value containing the string \'jira\' for Jira tracking software. Any other value will result in no links being made.", 3 );
                append( sb, "", 0 );

                append( sb, "issueManagementUrl", 2 );
                append( sb, "Used to create links to your issue tracking system for HTML reports. If unspecified, it will try to use the value specified in the issueManagement section of your project\'s POM.", 3 );
                append( sb, "", 0 );

                append( sb, "markdownChangeLogFilename (Default: changelog.md)", 2 );
                append( sb, "The filename of the markdown changelog, if generated.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The directory to put the reports in. Defaults to the project build directory (normally target).", 3 );
                append( sb, "", 0 );

                append( sb, "plainTextChangeLogFilename (Default: changelog.txt)", 2 );
                append( sb, "The filename of the plain text changelog, if generated.", 3 );
                append( sb, "", 0 );

                append( sb, "reportTitle", 2 );
                append( sb, "The title of the reports. Defaults to: ${project.name} v${project.version} changelog", 3 );
                append( sb, "", 0 );

                append( sb, "simpleHTMLChangeLogFilename (Default: changelog.html)", 2 );
                append( sb, "The filename of the simple HTML changelog, if generated.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "If true, the changelog will be printed to the Maven build log during packaging.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "gitlog:help", 0 );
            append( sb, "Display help information on maven-gitlog-plugin.\nCall\n\u00a0\u00a0mvn\u00a0gitlog:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "show".equals( goal ) )
        {
            append( sb, "gitlog:show", 0 );
            append( sb, "Displays the git log in the maven build log. Use the generate goal to generate reports.", 1 );
            append( sb, "", 0 );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
