/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog;

import com.github.danielflower.mavenplugins.gitlog.Defaults;
import com.github.danielflower.mavenplugins.gitlog.Generator;
import com.github.danielflower.mavenplugins.gitlog.NoGitRepositoryException;
import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import com.github.danielflower.mavenplugins.gitlog.renderers.GitHubIssueLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.JiraIssueLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.MarkdownRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.MavenLoggerRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.NullMessageConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.PlainTextRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.SimpleHtmlRenderer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GenerateMojo
extends AbstractMojo {
    private File outputDirectory;
    private String reportTitle;
    private boolean generatePlainTextChangeLog;
    private String plainTextChangeLogFilename;
    private boolean generateMarkdownChangeLog;
    private String markdownChangeLogFilename;
    private boolean generateSimpleHTMLChangeLog;
    private String simpleHTMLChangeLogFilename;
    private boolean generateHTMLTableOnlyChangeLog;
    private String htmlTableOnlyChangeLogFilename;
    private boolean verbose;
    private String issueManagementSystem;
    private String issueManagementUrl;
    private String dateFormat;
    private boolean fullGitMessage;
    private Date includeCommitsAfter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<ChangeLogRenderer> renderers;
        this.getLog().info((CharSequence)("Generating changelog in " + this.outputDirectory.getAbsolutePath() + " with title " + this.reportTitle));
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            renderers = this.createRenderers();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error while setting up gitlog renderers.  No changelog will be generated.", (Throwable)e);
            return;
        }
        Generator generator = new Generator(renderers, Defaults.COMMIT_FILTERS, this.getLog());
        try {
            generator.openRepository();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error opening git repository.  Is this Maven project hosted in a git repository? No changelog will be generated.", (Throwable)e);
            return;
        }
        catch (NoGitRepositoryException e) {
            this.getLog().warn((CharSequence)"This maven project does not appear to be in a git repository, therefore no git changelog will be generated.");
            return;
        }
        if (!"".equals(this.dateFormat)) {
            Formatter.setFormat(this.dateFormat, this.getLog());
        }
        try {
            generator.generate(this.reportTitle, this.includeCommitsAfter);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error while generating changelog.  Some changelogs may be incomplete or corrupt.", (Throwable)e);
        }
    }

    private List<ChangeLogRenderer> createRenderers() throws IOException {
        ArrayList<ChangeLogRenderer> renderers = new ArrayList<ChangeLogRenderer>();
        if (this.generatePlainTextChangeLog) {
            renderers.add(new PlainTextRenderer(this.getLog(), this.outputDirectory, this.plainTextChangeLogFilename, this.fullGitMessage));
        }
        if (this.generateSimpleHTMLChangeLog || this.generateHTMLTableOnlyChangeLog || this.generateMarkdownChangeLog) {
            MessageConverter messageConverter = this.getCommitMessageConverter();
            if (this.generateSimpleHTMLChangeLog) {
                renderers.add(new SimpleHtmlRenderer(this.getLog(), this.outputDirectory, this.simpleHTMLChangeLogFilename, this.fullGitMessage, messageConverter, false));
            }
            if (this.generateHTMLTableOnlyChangeLog) {
                renderers.add(new SimpleHtmlRenderer(this.getLog(), this.outputDirectory, this.htmlTableOnlyChangeLogFilename, this.fullGitMessage, messageConverter, true));
            }
            if (this.generateMarkdownChangeLog) {
                renderers.add(new MarkdownRenderer(this.getLog(), this.outputDirectory, this.markdownChangeLogFilename, this.fullGitMessage, messageConverter));
            }
        }
        if (this.verbose) {
            renderers.add(new MavenLoggerRenderer(this.getLog()));
        }
        return renderers;
    }

    private MessageConverter getCommitMessageConverter() {
        this.getLog().debug((CharSequence)("Trying to load issue tracking info: " + this.issueManagementSystem + " / " + this.issueManagementUrl));
        MessageConverter converter = null;
        try {
            if (this.issueManagementUrl != null && this.issueManagementUrl.contains("://")) {
                String system = ("" + this.issueManagementSystem).toLowerCase();
                if (system.contains("jira")) {
                    converter = new JiraIssueLinkConverter(this.getLog(), this.issueManagementUrl);
                } else if (system.contains("github")) {
                    converter = new GitHubIssueLinkConverter(this.getLog(), this.issueManagementUrl);
                }
            }
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Could not load issue management system information; no HTML links will be generated.", (Throwable)ex);
        }
        if (converter == null) {
            converter = new NullMessageConverter();
        }
        this.getLog().debug((CharSequence)("Using tracker " + converter.getClass().getSimpleName()));
        return converter;
    }
}

