/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.filters;

import com.github.danielflower.mavenplugins.gitlog.filters.CommitFilter;
import org.eclipse.jgit.revwalk.RevCommit;

public class DuplicateCommitMessageFilter
implements CommitFilter {
    private RevCommit previous;

    @Override
    public boolean renderCommit(RevCommit commit) {
        boolean isDuplicate = this.previous != null && this.messagesEquivalent(commit.getShortMessage(), this.previous.getShortMessage());
        this.previous = commit;
        return !isDuplicate;
    }

    private boolean messagesEquivalent(String message1, String message2) {
        message1 = "" + message1.trim().toLowerCase();
        message2 = "" + message2.trim().toLowerCase();
        return message1.equals(message2);
    }
}

