/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;

public class Formatter {
    public static String NEW_LINE = String.format("%n", new Object[0]);
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public static String formatDateTime() {
        return Formatter.formatDateTime(new Date());
    }

    public static String formatDateTime(int secondsSinceEpoch) {
        Date date = new Date((long)secondsSinceEpoch * 1000L);
        return Formatter.formatDateTime(date);
    }

    public static String formatDateTime(Date date) {
        return dateFormat.format(date);
    }

    public static void setFormat(String format, Log log) {
        try {
            dateFormat = new SimpleDateFormat(format);
        }
        catch (NullPointerException npe) {
            log.warn((CharSequence)String.format("Date format should not be null, using default: '%s'", DEFAULT_FORMAT));
            dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        }
        catch (IllegalArgumentException iae) {
            log.warn((CharSequence)String.format("Invalid date format '%s', using default: '%s'", format, DEFAULT_FORMAT));
            dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        }
    }
}

