/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class MarkdownLinkConverter {
    private Pattern pattern;
    private final Log log;

    public MarkdownLinkConverter(Log log) {
        this.log = log;
        this.pattern = Pattern.compile("<a\\s+href=(\"([^\"]+)\").*?>(.*?)</a>");
    }

    public String formatCommitMessage(String original) {
        try {
            Matcher matcher = this.pattern.matcher(original);
            String result = matcher.replaceAll("[$3]($2)");
            return result;
        }
        catch (Exception e) {
            this.log.info((CharSequence)("Unable to convert a HTML link into markdown link: " + original), (Throwable)e);
            return original;
        }
    }
}

