/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PomUpdater {
    private final Log log;
    private final List<MavenProject> projects;
    private final String newVersion;

    public PomUpdater(Log log, List<MavenProject> projects, String newVersion) {
        this.log = log;
        this.projects = projects;
        this.newVersion = newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> updateVersion() throws IOException {
        ArrayList<File> changedPoms = new ArrayList<File>();
        for (MavenProject project : this.projects) {
            this.log.info((CharSequence)("Going to release " + project.getArtifactId() + " " + this.newVersion));
            Model originalModel = project.getOriginalModel();
            this.alterModel(originalModel);
            File pom = project.getFile();
            changedPoms.add(pom);
            FileWriter fileWriter = new FileWriter(pom);
            try {
                MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                pomWriter.write((Writer)fileWriter, originalModel);
            }
            finally {
                ((Writer)fileWriter).close();
            }
        }
        return changedPoms;
    }

    private void alterModel(Model originalModel) {
        originalModel.setVersion(this.newVersion);
        Parent parent = originalModel.getParent();
        if (parent != null && this.isSnapshot(parent.getVersion())) {
            parent.setVersion(this.newVersion);
        }
        for (Dependency dependency : originalModel.getDependencies()) {
            if (!this.isSnapshot(dependency.getVersion())) continue;
            dependency.setVersion(this.newVersion);
        }
    }

    private boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }
}

