/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.PomUpdater;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

@Mojo(name="release", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class ReleaseMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    private List<MavenProject> projects;
    @Parameter(alias="releaseVersion", property="releaseVersion")
    private String releaseVersion;
    @Parameter(alias="releaseGoals")
    private List<String> goals;
    @Parameter(alias="skipTests", defaultValue="false", property="skipTests")
    private boolean skipTests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<File> changedFiles;
        String newVersion = new VersionNamer().name(this.project.getVersion(), this.releaseVersion);
        Git git = ReleaseMojo.loadGitDir();
        try {
            PomUpdater pomUpdater = new PomUpdater(this.getLog(), this.projects, newVersion);
            changedFiles = pomUpdater.updateVersion();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not update the version", (Exception)e);
        }
        try {
            this.deployReleasedProject();
        }
        finally {
            this.revertChanges(git, changedFiles);
        }
        try {
            for (MavenProject mavenProject : this.projects) {
                this.tagRepo(mavenProject.getArtifactId() + "-" + newVersion, git);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not access the git repository. Please make sure you are releasing from a git repo.", (Exception)e);
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("Could not tag the git repository", (Exception)((Object)e));
        }
    }

    private static Git loadGitDir() throws MojoExecutionException {
        Git git;
        File gitDir = new File(".");
        try {
            git = Git.open((File)gitDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open git repository. Is " + ReleaseMojo.pathOf(gitDir) + " a git repository?");
        }
        return git;
    }

    private static String pathOf(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e1) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private void revertChanges(Git git, List<File> changedFiles) throws MojoExecutionException {
        boolean hasErrors = false;
        File workTree = git.getRepository().getWorkTree();
        for (File changedFile : changedFiles) {
            try {
                String pathRelativeToWorkingTree = Repository.stripWorkDir((File)workTree, (File)changedFile);
                git.checkout().addPath(pathRelativeToWorkingTree).call();
            }
            catch (GitAPIException e) {
                hasErrors = true;
                this.getLog().error((CharSequence)("Unable to revert changes to " + changedFile + " - you may need to manually revert this file. Error was: " + e.getMessage()));
            }
        }
        if (hasErrors) {
            throw new MojoExecutionException("Could not revert changes - working directory is no longer clean. Please revert changes manually");
        }
    }

    private void deployReleasedProject() throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setInteractive(false);
        if (this.goals == null) {
            this.goals = Arrays.asList("deploy");
        }
        if (this.skipTests) {
            this.goals.add("-DskipTests=true");
        }
        request.setGoals(this.goals);
        ArrayList<String> profiles = new ArrayList<String>();
        for (Object activatedProfile : this.project.getActiveProfiles()) {
            profiles.add(((Profile)activatedProfile).getId());
        }
        request.setProfiles(profiles);
        String profilesInfo = profiles.size() == 0 ? "no profiles activated" : "profiles " + profiles;
        this.getLog().info((CharSequence)("About to run mvn " + this.goals + " with " + profilesInfo));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution returned code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to build artifact", (Exception)((Object)e));
        }
    }

    private void tagRepo(String tag, Git git) throws IOException, GitAPIException {
        this.getLog().info((CharSequence)("About to tag the repository with " + tag));
        Ref tagRef = git.tag().setAnnotated(true).setName(tag).setMessage("Release " + tag).call();
        git.push().add(tagRef).call();
    }
}

