/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import org.apache.maven.project.MavenProject;

public class ReleasableModule {
    private final MavenProject project;
    private final String releaseVersion;
    private final String tagName;
    private final String newVersion;

    public ReleasableModule(MavenProject project, String releaseVersion) throws ValidationException {
        this.project = project;
        this.releaseVersion = releaseVersion;
        this.newVersion = new VersionNamer().name(project.getVersion(), releaseVersion);
        this.tagName = project.getArtifactId() + "-" + this.newVersion;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public MavenProject getProject() {
        return this.project;
    }
}

