/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.PomUpdater;
import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

@Mojo(name="release", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class ReleaseMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    private List<MavenProject> projects;
    @Parameter(property="buildNumber")
    private String buildNumber;
    @Parameter(alias="releaseGoals")
    private List<String> goals;
    @Parameter(alias="skipTests", defaultValue="false", property="skipTests")
    private boolean skipTests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            List<File> changedFiles;
            Reactor reactor = Reactor.fromProjects(this.projects, this.buildNumber);
            Git git = ReleaseMojo.loadGitDir();
            List<String> tagNames = this.figureOutTagNamesAndThrowIfAlreadyExists(reactor.getModulesInBuildOrder(), git);
            try {
                PomUpdater pomUpdater = new PomUpdater(log, reactor);
                changedFiles = pomUpdater.updateVersion();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not update the version", (Exception)e);
            }
            try {
                this.deployReleasedProject();
            }
            finally {
                this.revertChanges(git, changedFiles);
            }
            try {
                for (String tagName : tagNames) {
                    this.tagRepo(tagName, git);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not access the git repository. Please make sure you are releasing from a git repo.", (Exception)e);
            }
            catch (GitAPIException e) {
                throw new MojoExecutionException("Could not tag the git repository", (Exception)((Object)e));
            }
        }
        catch (GitAPIException gae) {
            this.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage()));
        }
        catch (ValidationException e) {
            this.printBigErrorMessageAndThrow(log, e.getMessage(), e.getMessages());
        }
    }

    private List<String> figureOutTagNamesAndThrowIfAlreadyExists(List<ReleasableModule> modules, Git git) throws GitAPIException, ValidationException {
        ArrayList<String> names = new ArrayList<String>();
        for (ReleasableModule module : modules) {
            String tag = module.getTagName();
            if (GitHelper.hasLocalTag(git, tag)) {
                String summary = "There is already a tag named " + tag + " in this repository.";
                throw new ValidationException(summary, Arrays.asList(summary, "It is likely that this version has been released before.", "Please try incrementing the build number and trying again."));
            }
            names.add(tag);
        }
        return names;
    }

    private void printBigErrorMessageAndThrow(Log log, String terseMessage, List<String> linesToLog) throws MojoExecutionException {
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"Could not execute the release plugin");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        for (String line : linesToLog) {
            log.error((CharSequence)line);
        }
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        throw new MojoExecutionException(terseMessage);
    }

    private static Git loadGitDir() throws MojoExecutionException {
        Git git;
        File gitDir = new File(".");
        try {
            git = Git.open((File)gitDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open git repository. Is " + ReleaseMojo.pathOf(gitDir) + " a git repository?");
        }
        return git;
    }

    private static String pathOf(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e1) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private void revertChanges(Git git, List<File> changedFiles) throws MojoExecutionException {
        boolean hasErrors = false;
        File workTree = git.getRepository().getWorkTree();
        for (File changedFile : changedFiles) {
            try {
                String pathRelativeToWorkingTree = Repository.stripWorkDir((File)workTree, (File)changedFile);
                git.checkout().addPath(pathRelativeToWorkingTree).call();
            }
            catch (GitAPIException e) {
                hasErrors = true;
                this.getLog().error((CharSequence)("Unable to revert changes to " + changedFile + " - you may need to manually revert this file. Error was: " + e.getMessage()));
            }
        }
        if (hasErrors) {
            throw new MojoExecutionException("Could not revert changes - working directory is no longer clean. Please revert changes manually");
        }
    }

    private void deployReleasedProject() throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setInteractive(false);
        if (this.goals == null) {
            this.goals = Arrays.asList("deploy");
        }
        if (this.skipTests) {
            this.goals.add("-DskipTests=true");
        }
        request.setGoals(this.goals);
        ArrayList<String> profiles = new ArrayList<String>();
        for (Object activatedProfile : this.project.getActiveProfiles()) {
            profiles.add(((Profile)activatedProfile).getId());
        }
        request.setProfiles(profiles);
        String profilesInfo = profiles.size() == 0 ? "no profiles activated" : "profiles " + profiles;
        this.getLog().info((CharSequence)("About to run mvn " + this.goals + " with " + profilesInfo));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution returned code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to build artifact", (Exception)((Object)e));
        }
    }

    private void tagRepo(String tag, Git git) throws IOException, GitAPIException {
        this.getLog().info((CharSequence)("About to tag the repository with " + tag));
        Ref tagRef = git.tag().setAnnotated(true).setName(tag).setMessage("Release " + tag).call();
        git.push().add(tagRef).call();
    }
}

