/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.FileUtils;
import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class LocalGitRepo {
    public final Git git;
    private final String remoteUrl;
    private boolean hasReverted = false;

    LocalGitRepo(Git git, String remoteUrl) {
        this.git = git;
        this.remoteUrl = remoteUrl;
    }

    public void errorIfNotClean() throws ValidationException {
        Status status = this.currentStatus();
        boolean isClean = status.isClean();
        if (!isClean) {
            String summary = "Cannot release with uncommitted changes. Please check the following files:";
            ArrayList<String> message = new ArrayList<String>();
            message.add(summary);
            for (String path : status.getUncommittedChanges()) {
                message.add(" * " + path);
            }
            for (String path : status.getUntracked()) {
                message.add(" * " + path);
            }
            message.add("Please commit or revert these changes before releasing.");
            throw new ValidationException(summary, message);
        }
    }

    private Status currentStatus() throws ValidationException {
        Status status;
        try {
            status = this.git.status().call();
        }
        catch (GitAPIException e) {
            throw new ValidationException("Error while checking if the Git repo is clean", e);
        }
        return status;
    }

    public boolean revertChanges(Log log, List<File> changedFiles) throws MojoExecutionException {
        if (this.hasReverted) {
            return true;
        }
        boolean hasErrors = false;
        File workTree = this.git.getRepository().getWorkTree();
        for (File changedFile : changedFiles) {
            try {
                String pathRelativeToWorkingTree = Repository.stripWorkDir((File)workTree, (File)changedFile);
                this.git.checkout().addPath(pathRelativeToWorkingTree).call();
            }
            catch (Exception e) {
                hasErrors = true;
                log.error((CharSequence)("Unable to revert changes to " + changedFile + " - you may need to manually revert this file. Error was: " + e.getMessage()));
            }
        }
        this.hasReverted = true;
        return !hasErrors;
    }

    public boolean hasLocalTag(String tagName) throws GitAPIException {
        return GitHelper.hasLocalTag(this.git, tagName);
    }

    public void tagRepoAndPush(AnnotatedTag tag) throws GitAPIException {
        Ref tagRef = tag.saveAtHEAD(this.git);
        PushCommand pushCommand = this.git.push().add(tagRef);
        if (this.remoteUrl != null) {
            pushCommand.setRemote(this.remoteUrl);
        }
        pushCommand.call();
    }

    public static LocalGitRepo fromCurrentDir(String remoteUrl) throws ValidationException {
        Git git;
        File gitDir = new File(".");
        try {
            git = Git.open((File)gitDir);
        }
        catch (RepositoryNotFoundException rnfe) {
            String summary;
            String fullPathOfCurrentDir = FileUtils.pathOf(gitDir);
            File gitRoot = LocalGitRepo.getGitRootIfItExistsInOneOfTheParentDirectories(new File(fullPathOfCurrentDir));
            ArrayList<String> messages = new ArrayList<String>();
            if (gitRoot == null) {
                summary = "Releases can only be performed from Git repositories.";
                messages.add(summary);
                messages.add(fullPathOfCurrentDir + " is not a Git repository.");
            } else {
                summary = "The release plugin can only be run from the root folder of your Git repository";
                messages.add(summary);
                messages.add(fullPathOfCurrentDir + " is not the root of a Gir repository");
                messages.add("Try running the release plugin from " + FileUtils.pathOf(gitRoot));
            }
            throw new ValidationException(summary, messages);
        }
        catch (Exception e) {
            throw new ValidationException("Could not open git repository. Is " + FileUtils.pathOf(gitDir) + " a git repository?", Arrays.asList("Exception returned when accessing the git repo:", e.toString()));
        }
        return new LocalGitRepo(git, remoteUrl);
    }

    private static File getGitRootIfItExistsInOneOfTheParentDirectories(File candidateDir) {
        while (candidateDir != null && !candidateDir.getName().equals("target")) {
            if (new File(candidateDir, ".git").isDirectory()) {
                return candidateDir;
            }
            candidateDir = candidateDir.getParentFile();
        }
        return null;
    }

    public List<String> remoteTagsFrom(List<AnnotatedTag> tagNames) throws GitAPIException {
        ArrayList<String> results = new ArrayList<String>();
        LsRemoteCommand lsRemoteCommand = this.git.lsRemote().setTags(true).setHeads(false);
        if (this.remoteUrl != null) {
            lsRemoteCommand.setRemote(this.remoteUrl);
        }
        Collection remoteTags = lsRemoteCommand.call();
        for (Ref remoteTag : remoteTags) {
            for (AnnotatedTag proposedTag : tagNames) {
                if (!remoteTag.getName().equals("refs/tags/" + proposedTag.name())) continue;
                results.add(proposedTag.name());
            }
        }
        return results;
    }
}

