/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.AnnotatedTagFinder;
import com.github.danielflower.mavenplugins.release.Clock;
import com.github.danielflower.mavenplugins.release.DiffDetector;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.UnresolvedSnapshotDependencyException;
import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class Reactor {
    private final List<ReleasableModule> modulesInBuildOrder;

    public Reactor(List<ReleasableModule> modulesInBuildOrder) {
        this.modulesInBuildOrder = modulesInBuildOrder;
    }

    public List<ReleasableModule> getModulesInBuildOrder() {
        return this.modulesInBuildOrder;
    }

    public static Reactor fromProjects(Log log, Git git, MavenProject rootProject, List<MavenProject> projects, String buildNumber) throws ValidationException, GitAPIException, MojoExecutionException {
        DiffDetector detector = new DiffDetector(git.getRepository());
        ArrayList<ReleasableModule> modules = new ArrayList<ReleasableModule>();
        VersionNamer versionNamer = new VersionNamer(Clock.SystemClock);
        for (MavenProject project : projects) {
            String newVersion = versionNamer.name(project.getVersion(), buildNumber);
            boolean oneOfTheDependenciesHasChanged = false;
            String changedDependency = null;
            for (ReleasableModule module : modules) {
                if (module.willBeReleased()) {
                    for (Dependency dependency : project.getModel().getDependencies()) {
                        if (!dependency.getGroupId().equals(module.getGroupId()) || !dependency.getArtifactId().equals(module.getArtifactId())) continue;
                        oneOfTheDependenciesHasChanged = true;
                        changedDependency = dependency.getArtifactId();
                        break;
                    }
                }
                if (!oneOfTheDependenciesHasChanged) continue;
                break;
            }
            String equivalentVersion = null;
            String relativePathToModule = Reactor.calculateModulePath(rootProject, project);
            if (oneOfTheDependenciesHasChanged) {
                log.info((CharSequence)("Releasing " + project.getArtifactId() + " " + newVersion + " as " + changedDependency + " has changed."));
            } else {
                AnnotatedTag previousTagThatIsTheSameAsHEADForThisModule = Reactor.hasChangedSinceLastRelease(git, detector, project, relativePathToModule);
                if (previousTagThatIsTheSameAsHEADForThisModule != null) {
                    equivalentVersion = previousTagThatIsTheSameAsHEADForThisModule.version() + "." + previousTagThatIsTheSameAsHEADForThisModule.buildNumber();
                    log.info((CharSequence)("Will use version " + equivalentVersion + " for " + project.getArtifactId() + " as it has not been changed since that release."));
                } else {
                    log.debug((CharSequence)("Will use version " + newVersion + " for " + project.getArtifactId() + " as it has changed since the last release."));
                }
            }
            ReleasableModule module = new ReleasableModule(project, project.getVersion(), buildNumber, newVersion, equivalentVersion, relativePathToModule);
            modules.add(module);
        }
        if (!Reactor.atLeastOneBeingReleased(modules)) {
            log.warn((CharSequence)"No changes have been detected in any modules so will re-release them all");
            ArrayList<ReleasableModule> newList = new ArrayList<ReleasableModule>();
            for (ReleasableModule module : modules) {
                newList.add(module.createReleasableVersion());
            }
            modules = newList;
        }
        return new Reactor(modules);
    }

    private static boolean atLeastOneBeingReleased(List<ReleasableModule> modules) {
        for (ReleasableModule module : modules) {
            if (!module.willBeReleased()) continue;
            return true;
        }
        return false;
    }

    private static String calculateModulePath(MavenProject rootProject, MavenProject project) {
        String relativePathToModule = Repository.stripWorkDir((File)rootProject.getBasedir(), (File)project.getBasedir());
        if (relativePathToModule.length() == 0) {
            relativePathToModule = ".";
        }
        return relativePathToModule;
    }

    private static AnnotatedTag hasChangedSinceLastRelease(Git git, DiffDetector detector, MavenProject project, String relativePathToModule) throws MojoExecutionException {
        try {
            List<AnnotatedTag> previousTagsForThisModule = AnnotatedTagFinder.mostRecent(git, project.getArtifactId(), project.getVersion().replace("-SNAPSHOT", ""));
            if (previousTagsForThisModule.size() == 0) {
                return null;
            }
            boolean hasChanged = detector.hasChangedSince(relativePathToModule, project.getModel().getModules(), previousTagsForThisModule);
            return hasChanged ? null : previousTagsForThisModule.get(0);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while detecting whether or not " + project.getArtifactId() + " has changed since the last release", e);
        }
    }

    public ReleasableModule findByLabel(String label) {
        for (ReleasableModule module : this.modulesInBuildOrder) {
            String currentLabel = module.getGroupId() + ":" + module.getArtifactId();
            if (!currentLabel.equals(label)) continue;
            return module;
        }
        return null;
    }

    public ReleasableModule find(String groupId, String artifactId, String version) throws UnresolvedSnapshotDependencyException {
        ReleasableModule value = this.findByLabel(groupId + ":" + artifactId);
        if (value == null) {
            throw new UnresolvedSnapshotDependencyException(groupId, artifactId, version);
        }
        return value;
    }
}

