/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import java.util.List;
import org.apache.maven.project.MavenProject;

public class ReleasableModule {
    private final MavenProject project;
    private final String version;
    private final String buildNumber;
    private final String tagName;
    private final String newVersion;
    private final String equivalentVersion;
    private final String relativePathToModule;

    public ReleasableModule(MavenProject project, String version, String buildNumber, String newVersion, String equivalentVersion, String relativePathToModule) {
        this.project = project;
        this.version = version;
        this.buildNumber = buildNumber;
        this.newVersion = newVersion;
        this.equivalentVersion = equivalentVersion;
        this.relativePathToModule = relativePathToModule;
        this.tagName = project.getArtifactId() + "-" + this.newVersion;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isOneOf(List<String> moduleNames) {
        String modulePath = this.project.getBasedir().getName();
        for (String moduleName : moduleNames) {
            if (!modulePath.equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public boolean willBeReleased() {
        return this.equivalentVersion == null;
    }

    public String getVersionToDependOn() {
        return this.willBeReleased() ? this.newVersion : this.equivalentVersion;
    }

    public String getRelativePathToModule() {
        return this.relativePathToModule;
    }

    public ReleasableModule createReleasableVersion() {
        return new ReleasableModule(this.project, this.version, this.buildNumber, this.newVersion, null, this.relativePathToModule);
    }
}

