/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Guard;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class AnnotatedTag {
    public static final String VERSION = "version";
    public static final String BUILD_NUMBER = "buildNumber";
    private final String name;
    private final JSONObject message;
    private Ref ref;

    private AnnotatedTag(Ref ref, String name, JSONObject message) {
        Guard.notBlank("tag name", name);
        Guard.notNull("tag message", message);
        this.ref = ref;
        this.name = name;
        this.message = message;
    }

    public static AnnotatedTag create(String name, String version, String buildNumber) {
        JSONObject message = new JSONObject();
        message.put((Object)VERSION, (Object)version);
        message.put((Object)BUILD_NUMBER, (Object)buildNumber);
        return new AnnotatedTag(null, name, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnnotatedTag fromRef(Repository repository, Ref gitTag) throws IOException {
        JSONObject message;
        Guard.notNull("gitTag", gitTag);
        RevWalk walk = new RevWalk(repository);
        try {
            ObjectId tagId = gitTag.getObjectId();
            RevTag tag = walk.parseTag((AnyObjectId)tagId);
            message = (JSONObject)JSONValue.parse((String)tag.getFullMessage());
        }
        finally {
            walk.dispose();
        }
        if (message == null) {
            message = new JSONObject();
            message.put((Object)VERSION, (Object)"0");
            message.put((Object)BUILD_NUMBER, (Object)"0");
        }
        return new AnnotatedTag(gitTag, AnnotatedTag.stripRefPrefix(gitTag.getName()), message);
    }

    static String stripRefPrefix(String refName) {
        return refName.substring("refs/tags/".length());
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return String.valueOf(this.message.get((Object)VERSION));
    }

    public String buildNumber() {
        return String.valueOf(this.message.get((Object)BUILD_NUMBER));
    }

    public Ref saveAtHEAD(Git git) throws GitAPIException {
        String json = this.message.toJSONString();
        this.ref = git.tag().setName(this.name()).setAnnotated(true).setMessage(json).call();
        return this.ref;
    }

    public String toString() {
        return "AnnotatedTag{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedTag that = (AnnotatedTag)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Ref ref() {
        return this.ref;
    }
}

