/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class DiffDetector {
    private final Repository repo;

    public DiffDetector(Repository repo) {
        this.repo = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChangedSince(String modulePath, List<String> childModules, Collection<AnnotatedTag> tags) throws IOException {
        RevWalk walk = new RevWalk(this.repo);
        try {
            TreeFilter treeFilter;
            walk.setRetainBody(false);
            walk.markStart(walk.parseCommit((AnyObjectId)this.repo.getRef("HEAD").getObjectId()));
            if (".".equals(modulePath) && childModules.size() == 0) {
                treeFilter = TreeFilter.ANY_DIFF;
            } else {
                ArrayList<Object> treeFilters = new ArrayList<Object>();
                treeFilters.add(PathFilter.create((String)(modulePath + "/")));
                treeFilters.add(TreeFilter.ANY_DIFF);
                for (String childModule : childModules) {
                    treeFilters.add(PathFilter.create((String)(modulePath + "/" + childModule)).negate());
                }
                treeFilter = AndTreeFilter.create(treeFilters);
            }
            walk.setTreeFilter(treeFilter);
            for (AnnotatedTag tag : tags) {
                ObjectId commitId = tag.ref().getTarget().getObjectId();
                RevCommit revCommit = walk.parseCommit((AnyObjectId)commitId);
                walk.markUninteresting(revCommit);
            }
            boolean bl = walk.iterator().hasNext();
            return bl;
        }
        finally {
            walk.dispose();
        }
    }
}

