/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class AnnotatedTagFinder {
    public static List<AnnotatedTag> mostRecent(Git git, String module, String versionWithoutBuildNumber) throws GitAPIException, IOException {
        ArrayList<AnnotatedTag> results = new ArrayList<AnnotatedTag>();
        List tags = git.tagList().call();
        Collections.reverse(tags);
        String tagWithoutBuildNumber = module + "-" + versionWithoutBuildNumber;
        for (Ref tag : tags) {
            if (!AnnotatedTagFinder.isPotentiallySameVersionIgnoringBuildNumber(tagWithoutBuildNumber, tag.getName())) continue;
            results.add(AnnotatedTag.fromRef(git.getRepository(), tag));
            break;
        }
        return results;
    }

    static boolean isPotentiallySameVersionIgnoringBuildNumber(String versionWithoutBuildNumber, String refName) {
        String tagName = AnnotatedTag.stripRefPrefix(refName);
        return tagName.startsWith(versionWithoutBuildNumber + ".");
    }
}

