/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionName;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.lib.Repository;

public class VersionNamer {
    public VersionName name(String pomVersion, Long buildNumber, List<AnnotatedTag> previousTags) throws ValidationException {
        if (buildNumber == null) {
            buildNumber = previousTags == null || previousTags.size() == 0 ? Long.valueOf(0L) : Long.valueOf(VersionNamer.nextBuildNumber(previousTags));
        }
        VersionName versionName = new VersionName(pomVersion, pomVersion.replace("-SNAPSHOT", ""), buildNumber);
        if (!Repository.isValidRefName((String)("refs/tags/" + versionName.releaseVersion()))) {
            String summary = "Sorry, '" + versionName.releaseVersion() + "' is not a valid version.";
            throw new ValidationException(summary, Arrays.asList(summary, "Version numbers are used in the Git tag, and so can only contain characters that are valid in git tags.", "Please see https://www.kernel.org/pub/software/scm/git/docs/git-check-ref-format.html for tag naming rules."));
        }
        return versionName;
    }

    private static long nextBuildNumber(List<AnnotatedTag> previousTags) {
        long max = 0L;
        for (AnnotatedTag tag : previousTags) {
            max = Math.max(max, tag.buildNumber());
        }
        return max + 1L;
    }
}

