/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.UnresolvedSnapshotDependencyException;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PomUpdater {
    private final Log log;
    private final Reactor reactor;

    public PomUpdater(Log log, Reactor reactor) {
        this.log = log;
        this.reactor = reactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult updateVersion() {
        ArrayList<File> changedPoms = new ArrayList<File>();
        ArrayList<String> errors = new ArrayList<String>();
        for (ReleasableModule module : this.reactor.getModulesInBuildOrder()) {
            try {
                MavenProject project = module.getProject();
                if (module.willBeReleased()) {
                    this.log.info((CharSequence)("Going to release " + module.getArtifactId() + " " + module.getNewVersion()));
                }
                List<String> errorsForCurrentPom = this.alterModel(project, module.getNewVersion());
                errors.addAll(errorsForCurrentPom);
                File pom = project.getFile().getCanonicalFile();
                changedPoms.add(pom);
                FileWriter fileWriter = new FileWriter(pom);
                Model originalModel = project.getOriginalModel();
                try {
                    MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                    pomWriter.write((Writer)fileWriter, originalModel);
                }
                finally {
                    ((Writer)fileWriter).close();
                }
            }
            catch (Exception e) {
                return new UpdateResult(changedPoms, errors, e);
            }
        }
        return new UpdateResult(changedPoms, errors, null);
    }

    private List<String> alterModel(MavenProject project, String newVersion) {
        String version;
        Model originalModel = project.getOriginalModel();
        originalModel.setVersion(newVersion);
        ArrayList<String> errors = new ArrayList<String>();
        String searchingFrom = project.getArtifactId();
        MavenProject parent = project.getParent();
        if (parent != null && this.isSnapshot(parent.getVersion())) {
            try {
                ReleasableModule parentBeingReleased = this.reactor.find(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                originalModel.getParent().setVersion(parentBeingReleased.getVersionToDependOn());
            }
            catch (UnresolvedSnapshotDependencyException e) {
                errors.add("The parent of " + searchingFrom + " is " + e.artifactId + " " + e.version);
            }
        }
        for (Dependency dependency : originalModel.getDependencies()) {
            version = dependency.getVersion();
            if (!this.isSnapshot(version)) continue;
            try {
                ReleasableModule dependencyBeingReleased = this.reactor.find(dependency.getGroupId(), dependency.getArtifactId(), version);
                dependency.setVersion(dependencyBeingReleased.getVersionToDependOn());
            }
            catch (UnresolvedSnapshotDependencyException e) {
                errors.add(searchingFrom + " references dependency " + e.artifactId + " " + e.version);
            }
        }
        for (Plugin plugin : project.getModel().getBuild().getPlugins()) {
            version = plugin.getVersion();
            if (!this.isSnapshot(version) || PomUpdater.isMultiModuleReleasePlugin(plugin)) continue;
            errors.add(searchingFrom + " references plugin " + plugin.getArtifactId() + " " + version);
        }
        return errors;
    }

    private static boolean isMultiModuleReleasePlugin(Plugin plugin) {
        return plugin.getGroupId().equals("com.github.danielflower.mavenplugins") && plugin.getArtifactId().equals("multi-module-maven-release-plugin");
    }

    private boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public static class UpdateResult {
        public final List<File> alteredPoms;
        public final List<String> dependencyErrors;
        public final Exception unexpectedException;

        public UpdateResult(List<File> alteredPoms, List<String> dependencyErrors, Exception unexpectedException) {
            this.alteredPoms = alteredPoms;
            this.dependencyErrors = dependencyErrors;
            this.unexpectedException = unexpectedException;
        }

        public boolean success() {
            return this.dependencyErrors.size() == 0 && this.unexpectedException == null;
        }
    }
}

