/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.AnnotatedTagFinder;
import com.github.danielflower.mavenplugins.release.DiffDetector;
import com.github.danielflower.mavenplugins.release.LocalGitRepo;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.UnresolvedSnapshotDependencyException;
import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionName;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class Reactor {
    private final List<ReleasableModule> modulesInBuildOrder;

    public Reactor(List<ReleasableModule> modulesInBuildOrder) {
        this.modulesInBuildOrder = modulesInBuildOrder;
    }

    public List<ReleasableModule> getModulesInBuildOrder() {
        return this.modulesInBuildOrder;
    }

    public static Reactor fromProjects(Log log, LocalGitRepo gitRepo, MavenProject rootProject, List<MavenProject> projects, Long buildNumber) throws ValidationException, GitAPIException, MojoExecutionException {
        DiffDetector detector = new DiffDetector(gitRepo.git.getRepository());
        ArrayList<ReleasableModule> modules = new ArrayList<ReleasableModule>();
        VersionNamer versionNamer = new VersionNamer();
        for (MavenProject project : projects) {
            ReleasableModule module2;
            String relativePathToModule = Reactor.calculateModulePath(rootProject, project);
            String artifactId = project.getArtifactId();
            String versionWithoutBuildNumber = project.getVersion().replace("-SNAPSHOT", "");
            List<AnnotatedTag> previousTagsForThisModule = AnnotatedTagFinder.tagsForVersion(gitRepo.git, artifactId, versionWithoutBuildNumber);
            ArrayList<Long> previousBuildNumbers = new ArrayList<Long>();
            if (previousTagsForThisModule != null) {
                for (AnnotatedTag previousTag : previousTagsForThisModule) {
                    previousBuildNumbers.add(previousTag.buildNumber());
                }
            }
            Collection<Long> remoteBuildNumbers = Reactor.getRemoteBuildNumbers(gitRepo, artifactId, versionWithoutBuildNumber);
            previousBuildNumbers.addAll(remoteBuildNumbers);
            VersionName newVersion = versionNamer.name(project.getVersion(), buildNumber, previousBuildNumbers);
            boolean oneOfTheDependenciesHasChanged = false;
            String changedDependency = null;
            for (ReleasableModule module2 : modules) {
                if (module2.willBeReleased()) {
                    for (Dependency dependency : project.getModel().getDependencies()) {
                        if (!dependency.getGroupId().equals(module2.getGroupId()) || !dependency.getArtifactId().equals(module2.getArtifactId())) continue;
                        oneOfTheDependenciesHasChanged = true;
                        changedDependency = dependency.getArtifactId();
                        break;
                    }
                    if (project.getParent() != null && project.getParent().getGroupId().equals(module2.getGroupId()) && project.getParent().getArtifactId().equals(module2.getArtifactId())) {
                        oneOfTheDependenciesHasChanged = true;
                        changedDependency = project.getParent().getArtifactId();
                        break;
                    }
                }
                if (!oneOfTheDependenciesHasChanged) continue;
                break;
            }
            String equivalentVersion = null;
            if (oneOfTheDependenciesHasChanged) {
                log.info((CharSequence)("Releasing " + artifactId + " " + newVersion.releaseVersion() + " as " + changedDependency + " has changed."));
            } else {
                AnnotatedTag previousTagThatIsTheSameAsHEADForThisModule = Reactor.hasChangedSinceLastRelease(previousTagsForThisModule, detector, project, relativePathToModule);
                if (previousTagThatIsTheSameAsHEADForThisModule != null) {
                    equivalentVersion = previousTagThatIsTheSameAsHEADForThisModule.version() + "." + previousTagThatIsTheSameAsHEADForThisModule.buildNumber();
                    log.info((CharSequence)("Will use version " + equivalentVersion + " for " + artifactId + " as it has not been changed since that release."));
                } else {
                    log.debug((CharSequence)("Will use version " + newVersion.releaseVersion() + " for " + artifactId + " as it has changed since the last release."));
                }
            }
            module2 = new ReleasableModule(project, newVersion, equivalentVersion, relativePathToModule);
            modules.add(module2);
        }
        if (!Reactor.atLeastOneBeingReleased(modules)) {
            log.warn((CharSequence)"No changes have been detected in any modules so will re-release them all");
            ArrayList<ReleasableModule> newList = new ArrayList<ReleasableModule>();
            for (ReleasableModule module : modules) {
                newList.add(module.createReleasableVersion());
            }
            modules = newList;
        }
        return new Reactor(modules);
    }

    private static Collection<Long> getRemoteBuildNumbers(LocalGitRepo gitRepo, String artifactId, String versionWithoutBuildNumber) throws GitAPIException {
        Collection<Ref> remoteTagRefs = gitRepo.allRemoteTags();
        ArrayList<Long> remoteBuildNumbers = new ArrayList<Long>();
        String tagWithoutBuildNumber = artifactId + "-" + versionWithoutBuildNumber;
        for (Ref remoteTagRef : remoteTagRefs) {
            String remoteTagName = remoteTagRef.getName();
            Long buildNumber = AnnotatedTagFinder.buildNumberOf(tagWithoutBuildNumber, remoteTagName);
            if (buildNumber == null) continue;
            remoteBuildNumbers.add(buildNumber);
        }
        return remoteBuildNumbers;
    }

    private static boolean atLeastOneBeingReleased(List<ReleasableModule> modules) {
        for (ReleasableModule module : modules) {
            if (!module.willBeReleased()) continue;
            return true;
        }
        return false;
    }

    private static String calculateModulePath(MavenProject rootProject, MavenProject project) throws MojoExecutionException {
        File moduleRoot;
        File projectRoot;
        try {
            projectRoot = rootProject.getBasedir().getCanonicalFile();
            moduleRoot = project.getBasedir().getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not find directory paths for maven project", (Exception)e);
        }
        String relativePathToModule = Repository.stripWorkDir((File)projectRoot, (File)moduleRoot);
        if (relativePathToModule.length() == 0) {
            relativePathToModule = ".";
        }
        return relativePathToModule;
    }

    private static AnnotatedTag hasChangedSinceLastRelease(List<AnnotatedTag> previousTagsForThisModule, DiffDetector detector, MavenProject project, String relativePathToModule) throws MojoExecutionException {
        try {
            if (previousTagsForThisModule.size() == 0) {
                return null;
            }
            boolean hasChanged = detector.hasChangedSince(relativePathToModule, project.getModel().getModules(), previousTagsForThisModule);
            return hasChanged ? null : previousTagsForThisModule.get(0);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while detecting whether or not " + project.getArtifactId() + " has changed since the last release", e);
        }
    }

    public ReleasableModule findByLabel(String label) {
        for (ReleasableModule module : this.modulesInBuildOrder) {
            String currentLabel = module.getGroupId() + ":" + module.getArtifactId();
            if (!currentLabel.equals(label)) continue;
            return module;
        }
        return null;
    }

    public ReleasableModule find(String groupId, String artifactId, String version) throws UnresolvedSnapshotDependencyException {
        ReleasableModule value = this.findByLabel(groupId + ":" + artifactId);
        if (value == null) {
            throw new UnresolvedSnapshotDependencyException(groupId, artifactId, version);
        }
        return value;
    }
}

