/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.LocalGitRepo;
import com.github.danielflower.mavenplugins.release.PomUpdater;
import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.SshAgentSessionFactory;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.SshSessionFactory;

@Mojo(name="release", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class ReleaseMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    private List<MavenProject> projects;
    @Parameter(property="buildNumber")
    private Long buildNumber;
    @Parameter(alias="releaseGoals")
    private List<String> goals;
    @Parameter(alias="releaseProfiles")
    private List<String> releaseProfiles;
    @Parameter(alias="skipTests", defaultValue="false", property="skipTests")
    private boolean skipTests;
    @Parameter(alias="modulesToRelease", property="modulesToRelease")
    private List<String> modulesToRelease;
    @Parameter(property="disableSshAgent")
    private boolean disableSshAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            this.configureJsch(log);
            LocalGitRepo repo = LocalGitRepo.fromCurrentDir(ReleaseMojo.getRemoteUrlOrNullIfNoneSet(this.project.getScm()));
            repo.errorIfNotClean();
            Reactor reactor = Reactor.fromProjects(log, repo, this.project, this.projects, this.buildNumber);
            List<AnnotatedTag> proposedTags = ReleaseMojo.figureOutTagNamesAndThrowIfAlreadyExists(reactor.getModulesInBuildOrder(), repo, this.modulesToRelease);
            List<File> changedFiles = ReleaseMojo.updatePomsAndReturnChangedFiles(log, repo, reactor);
            this.tagAndPushRepo(log, repo, proposedTags);
            try {
                this.runMavenBuild(reactor);
                ReleaseMojo.revertChanges(log, repo, changedFiles, true);
            }
            finally {
                ReleaseMojo.revertChanges(log, repo, changedFiles, false);
            }
        }
        catch (ValidationException e) {
            ReleaseMojo.printBigErrorMessageAndThrow(log, e.getMessage(), e.getMessages());
        }
        catch (GitAPIException gae) {
            StringWriter sw = new StringWriter();
            gae.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            ReleaseMojo.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage(), "Stack trace:", exceptionAsString));
        }
    }

    private void configureJsch(Log log) {
        if (!this.disableSshAgent) {
            JschConfigSessionFactory.setInstance((SshSessionFactory)new SshAgentSessionFactory(log));
        }
    }

    private void tagAndPushRepo(Log log, LocalGitRepo repo, List<AnnotatedTag> proposedTags) throws GitAPIException {
        for (AnnotatedTag proposedTag : proposedTags) {
            log.info((CharSequence)("About to tag the repository with " + proposedTag.name()));
            repo.tagRepoAndPush(proposedTag);
        }
    }

    private static String getRemoteUrlOrNullIfNoneSet(Scm scm) throws ValidationException {
        if (scm == null) {
            return null;
        }
        String remote = scm.getDeveloperConnection();
        if (remote == null) {
            remote = scm.getConnection();
        }
        if (remote == null) {
            return null;
        }
        return GitHelper.scmUrlToRemote(remote);
    }

    private static void revertChanges(Log log, LocalGitRepo repo, List<File> changedFiles, boolean throwIfError) throws MojoExecutionException {
        if (!repo.revertChanges(log, changedFiles)) {
            String message = "Could not revert changes - working directory is no longer clean. Please revert changes manually";
            if (throwIfError) {
                throw new MojoExecutionException(message);
            }
            log.warn((CharSequence)message);
        }
    }

    private static List<File> updatePomsAndReturnChangedFiles(Log log, LocalGitRepo repo, Reactor reactor) throws MojoExecutionException, ValidationException {
        PomUpdater pomUpdater = new PomUpdater(log, reactor);
        PomUpdater.UpdateResult result = pomUpdater.updateVersion();
        if (!result.success()) {
            log.info((CharSequence)"Going to revert changes because there was an error.");
            repo.revertChanges(log, result.alteredPoms);
            if (result.unexpectedException != null) {
                throw new ValidationException("Unexpected exception while setting the release versions in the pom", result.unexpectedException);
            }
            String summary = "Cannot release with references to snapshot dependencies";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            messages.add("The following dependency errors were found:");
            for (String dependencyError : result.dependencyErrors) {
                messages.add(" * " + dependencyError);
            }
            throw new ValidationException(summary, messages);
        }
        return result.alteredPoms;
    }

    private static List<AnnotatedTag> figureOutTagNamesAndThrowIfAlreadyExists(List<ReleasableModule> modules, LocalGitRepo git, List<String> modulesToRelease) throws GitAPIException, ValidationException {
        ArrayList<AnnotatedTag> tags = new ArrayList<AnnotatedTag>();
        for (ReleasableModule module : modules) {
            if (!module.willBeReleased() || modulesToRelease != null && modulesToRelease.size() != 0 && !module.isOneOf(modulesToRelease)) continue;
            String tag = module.getTagName();
            if (git.hasLocalTag(tag)) {
                String summary = "There is already a tag named " + tag + " in this repository.";
                throw new ValidationException(summary, Arrays.asList(summary, "It is likely that this version has been released before.", "Please try incrementing the build number and trying again."));
            }
            AnnotatedTag annotatedTag = AnnotatedTag.create(tag, module.getVersion(), module.getBuildNumber());
            tags.add(annotatedTag);
        }
        List<String> matchingRemoteTags = git.remoteTagsFrom(tags);
        if (matchingRemoteTags.size() > 0) {
            String summary = "Cannot release because there is already a tag with the same build number on the remote Git repo.";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            for (String matchingRemoteTag : matchingRemoteTags) {
                messages.add(" * There is already a tag named " + matchingRemoteTag + " in the remote repo.");
            }
            messages.add("Please try releasing again with a new build number.");
            throw new ValidationException(summary, messages);
        }
        return tags;
    }

    private static void printBigErrorMessageAndThrow(Log log, String terseMessage, List<String> linesToLog) throws MojoExecutionException {
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"Could not execute the release plugin");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        for (String line : linesToLog) {
            log.error((CharSequence)line);
        }
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        throw new MojoExecutionException(terseMessage);
    }

    private void runMavenBuild(Reactor reactor) throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setInteractive(false);
        if (this.goals == null) {
            this.goals = Arrays.asList("deploy");
        }
        if (this.skipTests) {
            this.goals.add("-DskipTests=true");
        }
        request.setShowErrors(true);
        request.setDebug(this.getLog().isDebugEnabled());
        request.setGoals(this.goals);
        List<String> profiles = this.profilesToActivate();
        request.setProfiles(profiles);
        request.setAlsoMake(true);
        ArrayList<String> changedModules = new ArrayList<String>();
        for (ReleasableModule releasableModule : reactor.getModulesInBuildOrder()) {
            boolean userImplicitlyWantsThisToBeReleased;
            String modulePath = releasableModule.getRelativePathToModule();
            boolean userExplicitlyWantsThisToBeReleased = this.modulesToRelease.contains(modulePath);
            boolean bl = userImplicitlyWantsThisToBeReleased = this.modulesToRelease == null || this.modulesToRelease.size() == 0;
            if (!userExplicitlyWantsThisToBeReleased && (!userImplicitlyWantsThisToBeReleased || !releasableModule.willBeReleased())) continue;
            changedModules.add(modulePath);
        }
        request.setProjects(changedModules);
        String profilesInfo = profiles.size() == 0 ? "no profiles activated" : "profiles " + profiles;
        this.getLog().info((CharSequence)("About to run mvn " + this.goals + " with " + profilesInfo));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution returned code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to build artifact", (Exception)((Object)e));
        }
    }

    private List<String> profilesToActivate() {
        ArrayList<String> profiles = new ArrayList<String>();
        if (this.releaseProfiles != null) {
            for (String releaseProfile : this.releaseProfiles) {
                profiles.add(releaseProfile);
            }
        }
        for (String activatedProfile : this.project.getActiveProfiles()) {
            profiles.add(((Profile)activatedProfile).getId());
        }
        return profiles;
    }
}

