/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.LocalGitRepo;
import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.SshAgentSessionFactory;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.SshSessionFactory;

@Mojo(name="next", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class NextMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    private List<MavenProject> projects;
    @Parameter(property="buildNumber")
    private Long buildNumber;
    @Parameter(alias="modulesToRelease", property="modulesToRelease")
    private List<String> modulesToRelease;
    @Parameter(alias="forceRelease", property="forceRelease")
    private List<String> modulesToForceRelease;
    @Parameter(property="disableSshAgent")
    private boolean disableSshAgent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            this.configureJsch(log);
            LocalGitRepo repo = LocalGitRepo.fromCurrentDir(NextMojo.getRemoteUrlOrNullIfNoneSet(this.project.getScm()));
            Reactor reactor = Reactor.fromProjects(log, repo, this.project, this.projects, this.buildNumber, this.modulesToForceRelease);
            NextMojo.figureOutTagNamesAndThrowIfAlreadyExists(reactor.getModulesInBuildOrder(), repo, this.modulesToRelease);
        }
        catch (ValidationException e) {
            NextMojo.printBigErrorMessageAndThrow(log, e.getMessage(), e.getMessages());
        }
        catch (GitAPIException gae) {
            StringWriter sw = new StringWriter();
            gae.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            NextMojo.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage(), "Stack trace:", exceptionAsString));
        }
    }

    private void configureJsch(Log log) {
        if (!this.disableSshAgent) {
            JschConfigSessionFactory.setInstance((SshSessionFactory)new SshAgentSessionFactory(log));
        }
    }

    private static String getRemoteUrlOrNullIfNoneSet(Scm scm) throws ValidationException {
        if (scm == null) {
            return null;
        }
        String remote = scm.getDeveloperConnection();
        if (remote == null) {
            remote = scm.getConnection();
        }
        if (remote == null) {
            return null;
        }
        return GitHelper.scmUrlToRemote(remote);
    }

    private static List<AnnotatedTag> figureOutTagNamesAndThrowIfAlreadyExists(List<ReleasableModule> modules, LocalGitRepo git, List<String> modulesToRelease) throws GitAPIException, ValidationException {
        ArrayList<AnnotatedTag> tags = new ArrayList<AnnotatedTag>();
        for (ReleasableModule module : modules) {
            if (!module.willBeReleased() || modulesToRelease != null && modulesToRelease.size() != 0 && !module.isOneOf(modulesToRelease)) continue;
            String tag = module.getTagName();
            if (git.hasLocalTag(tag)) {
                String summary = "There is already a tag named " + tag + " in this repository.";
                throw new ValidationException(summary, Arrays.asList(summary, "It is likely that this version has been released before.", "Please try incrementing the build number and trying again."));
            }
            AnnotatedTag annotatedTag = AnnotatedTag.create(tag, module.getVersion(), module.getBuildNumber());
            tags.add(annotatedTag);
        }
        List<String> matchingRemoteTags = git.remoteTagsFrom(tags);
        if (matchingRemoteTags.size() > 0) {
            String summary = "Cannot release because there is already a tag with the same build number on the remote Git repo.";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            for (String matchingRemoteTag : matchingRemoteTags) {
                messages.add(" * There is already a tag named " + matchingRemoteTag + " in the remote repo.");
            }
            messages.add("Please try releasing again with a new build number.");
            throw new ValidationException(summary, messages);
        }
        return tags;
    }

    private static void printBigErrorMessageAndThrow(Log log, String terseMessage, List<String> linesToLog) throws MojoExecutionException {
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"Could not execute the release plugin");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        for (String line : linesToLog) {
            log.error((CharSequence)line);
        }
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        throw new MojoExecutionException(terseMessage);
    }
}

