/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.Ref;

public class AnnotatedTagFinder {
    public static List<AnnotatedTag> tagsForVersion(Git git, String module, String versionWithoutBuildNumber) throws MojoExecutionException {
        List tags;
        ArrayList<AnnotatedTag> results = new ArrayList<AnnotatedTag>();
        try {
            tags = git.tagList().call();
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("Error while getting a list of tags in the local repo", (Exception)((Object)e));
        }
        Collections.reverse(tags);
        String tagWithoutBuildNumber = module + "-" + versionWithoutBuildNumber;
        for (Ref tag : tags) {
            if (!AnnotatedTagFinder.isPotentiallySameVersionIgnoringBuildNumber(tagWithoutBuildNumber, tag.getName())) continue;
            try {
                results.add(AnnotatedTag.fromRef(git.getRepository(), tag));
            }
            catch (IncorrectObjectTypeException ignored) {
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while looking up tag " + tag, (Exception)e);
            }
        }
        return results;
    }

    public static boolean isPotentiallySameVersionIgnoringBuildNumber(String versionWithoutBuildNumber, String refName) {
        return AnnotatedTagFinder.buildNumberOf(versionWithoutBuildNumber, refName) != null;
    }

    public static Long buildNumberOf(String versionWithoutBuildNumber, String refName) {
        String prefix;
        String tagName = AnnotatedTag.stripRefPrefix(refName);
        if (tagName.startsWith(prefix = versionWithoutBuildNumber + ".")) {
            String end = tagName.substring(prefix.length());
            try {
                return Long.parseLong(end);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

