/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.TagPusher;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

class RemoteTagPusher
implements TagPusher {
    private final Git git;
    private final String remoteUrl;

    public RemoteTagPusher(Git git, String remoteUrl) {
        this.git = git;
        this.remoteUrl = remoteUrl;
    }

    @Override
    public void pushTags(Collection<AnnotatedTag> tags) throws GitAPIException {
        PushCommand pushCommand = this.git.push();
        if (this.remoteUrl != null) {
            pushCommand.setRemote(this.remoteUrl);
        }
        for (AnnotatedTag tag : tags) {
            pushCommand.add(tag.saveAtHEAD(this.git));
        }
        pushCommand.call();
    }
}

