/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.BaseMojo;
import com.github.danielflower.mavenplugins.release.GitOperations;
import com.github.danielflower.mavenplugins.release.LocalGitRepo;
import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleaseMojo;
import com.github.danielflower.mavenplugins.release.ResolverWrapper;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="next", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class NextMojo
extends BaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            ResolverWrapper resolverWrapper;
            LocalGitRepo repo;
            Reactor reactor;
            this.configureJsch(log);
            EnumSet<GitOperations> gitOperations = EnumSet.noneOf(GitOperations.class);
            if (this.pullTags) {
                gitOperations.add(GitOperations.PULL_TAGS);
            }
            if ((reactor = Reactor.fromProjects(log, repo = new LocalGitRepo.Builder().remoteGitOperationsAllowed(gitOperations).remoteGitUrl(NextMojo.getRemoteUrlOrNullIfNoneSet(this.project.getOriginalModel().getScm(), this.project.getModel().getScm())).credentialsProvider(this.getCredentialsProvider()).buildFromCurrentDir(), this.project, this.projects, this.buildNumber, this.modulesToForceRelease, this.noChangesAction, resolverWrapper = new ResolverWrapper(this.factory, this.artifactResolver, this.remoteRepositories, this.localRepository), this.versionNamer)) == null) {
                return;
            }
            ReleaseMojo.figureOutTagNamesAndThrowIfAlreadyExists(reactor.getModulesInBuildOrder(), repo, this.modulesToRelease);
        }
        catch (ValidationException e) {
            NextMojo.printBigErrorMessageAndThrow(log, e.getMessage(), e.getMessages());
        }
        catch (GitAPIException gae) {
            StringWriter sw = new StringWriter();
            gae.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            NextMojo.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage(), "Stack trace:", exceptionAsString));
        }
    }
}

