/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.BaseMojo;
import com.github.danielflower.mavenplugins.release.GitOperations;
import com.github.danielflower.mavenplugins.release.LocalGitRepo;
import com.github.danielflower.mavenplugins.release.PomUpdater;
import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.ReleaseInvoker;
import com.github.danielflower.mavenplugins.release.ResolverWrapper;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="release", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class ReleaseMojo
extends BaseMojo {
    @Parameter(alias="releaseGoals")
    private List<String> goals;
    @Parameter(alias="releaseProfiles")
    private List<String> releaseProfiles;
    @Parameter(alias="skipTests", defaultValue="false", property="skipTests")
    private boolean skipTests;
    @Parameter(alias="userSettings")
    private File userSettings;
    @Parameter(alias="globalSettings")
    private File globalSettings;
    @Parameter(alias="pushTags", defaultValue="true", property="push")
    private boolean pushTags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            this.configureJsch(log);
            EnumSet<GitOperations> gitOperations = EnumSet.noneOf(GitOperations.class);
            if (this.pullTags) {
                gitOperations.add(GitOperations.PULL_TAGS);
            }
            if (this.pushTags) {
                gitOperations.add(GitOperations.PUSH_TAGS);
            }
            LocalGitRepo repo = new LocalGitRepo.Builder().remoteGitOperationsAllowed(gitOperations).remoteGitUrl(ReleaseMojo.getRemoteUrlOrNullIfNoneSet(this.project.getOriginalModel().getScm(), this.project.getModel().getScm())).credentialsProvider(this.getCredentialsProvider(log)).buildFromCurrentDir();
            repo.errorIfNotClean();
            ResolverWrapper resolverWrapper = new ResolverWrapper(this.factory, this.artifactResolver, this.remoteRepositories, this.localRepository);
            Reactor reactor = Reactor.fromProjects(log, repo, this.project, this.projects, this.buildNumber, this.modulesToForceRelease, this.noChangesAction, resolverWrapper, this.versionNamer);
            if (reactor == null) {
                return;
            }
            List<AnnotatedTag> proposedTags = ReleaseMojo.figureOutTagNamesAndThrowIfAlreadyExists(reactor.getModulesInBuildOrder(), repo, this.modulesToRelease);
            List<File> changedFiles = ReleaseMojo.updatePomsAndReturnChangedFiles(log, repo, reactor);
            this.tagAndPushRepo(log, repo, proposedTags);
            try {
                ReleaseInvoker invoker = new ReleaseInvoker(this.getLog(), this.project);
                invoker.setGlobalSettings(this.globalSettings);
                if (this.userSettings != null) {
                    invoker.setUserSettings(this.userSettings);
                } else if (this.getSettings() != null) {
                    File settingsFile = File.createTempFile("tmp", ".xml");
                    settingsFile.deleteOnExit();
                    new DefaultSettingsWriter().write(settingsFile, null, this.getSettings());
                    invoker.setUserSettings(settingsFile);
                }
                invoker.setGoals(this.goals);
                invoker.setModulesToRelease(this.modulesToRelease);
                invoker.setReleaseProfiles(this.releaseProfiles);
                invoker.setSkipTests(this.skipTests);
                invoker.setArguments(this.arguments);
                invoker.runMavenBuild(reactor);
                ReleaseMojo.revertChanges(log, repo, changedFiles, true);
            }
            finally {
                ReleaseMojo.revertChanges(log, repo, changedFiles, false);
            }
        }
        catch (ValidationException e) {
            ReleaseMojo.printBigErrorMessageAndThrow(log, e.getMessage(), e.getMessages());
        }
        catch (GitAPIException gae) {
            StringWriter sw = new StringWriter();
            gae.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            ReleaseMojo.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage(), "Stack trace:", exceptionAsString));
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            ReleaseMojo.printBigErrorMessageAndThrow(log, e.getMessage(), Arrays.asList("There was an error while creating temporary settings file. The error was:", e.getMessage(), "Stack trace:", exceptionAsString));
        }
    }

    private void tagAndPushRepo(Log log, LocalGitRepo repo, List<AnnotatedTag> proposedTags) throws GitAPIException {
        for (AnnotatedTag proposedTag : proposedTags) {
            log.info((CharSequence)("About to tag the repository with " + proposedTag.name()));
        }
        repo.tagAndPushRepo(proposedTags);
    }

    private static void revertChanges(Log log, LocalGitRepo repo, List<File> changedFiles, boolean throwIfError) throws MojoExecutionException {
        if (!repo.revertChanges(log, changedFiles)) {
            String message = "Could not revert changes - working directory is no longer clean. Please revert changes manually";
            if (throwIfError) {
                throw new MojoExecutionException(message);
            }
            log.warn((CharSequence)message);
        }
    }

    private static List<File> updatePomsAndReturnChangedFiles(Log log, LocalGitRepo repo, Reactor reactor) throws MojoExecutionException, ValidationException {
        PomUpdater pomUpdater = new PomUpdater(log, reactor);
        PomUpdater.UpdateResult result = pomUpdater.updateVersion();
        if (!result.success()) {
            log.info((CharSequence)"Going to revert changes because there was an error.");
            repo.revertChanges(log, result.alteredPoms);
            if (result.unexpectedException != null) {
                throw new ValidationException("Unexpected exception while setting the release versions in the pom", result.unexpectedException);
            }
            String summary = "Cannot release with references to snapshot dependencies";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            messages.add("The following dependency errors were found:");
            for (String dependencyError : result.dependencyErrors) {
                messages.add(" * " + dependencyError);
            }
            throw new ValidationException(summary, messages);
        }
        return result.alteredPoms;
    }

    static List<AnnotatedTag> figureOutTagNamesAndThrowIfAlreadyExists(List<ReleasableModule> modules, LocalGitRepo git, List<String> modulesToRelease) throws GitAPIException, ValidationException {
        ArrayList<AnnotatedTag> tags = new ArrayList<AnnotatedTag>();
        for (ReleasableModule module : modules) {
            if (!module.willBeReleased() || modulesToRelease != null && modulesToRelease.size() != 0 && !module.isOneOf(modulesToRelease)) continue;
            String tag = module.getTagName();
            if (git.hasLocalTag(tag)) {
                String summary = "There is already a tag named " + tag + " in this repository.";
                throw new ValidationException(summary, Arrays.asList(summary, "It is likely that this version has been released before.", "Please try incrementing the build number and trying again."));
            }
            AnnotatedTag annotatedTag = AnnotatedTag.create(tag, module.getVersion(), module.getBuildNumber());
            tags.add(annotatedTag);
        }
        List<String> matchingRemoteTags = git.tagsFrom(tags);
        if (matchingRemoteTags.size() > 0) {
            String summary = "Cannot release because there is already a tag with the same build number on the remote Git repo.";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            for (String matchingRemoteTag : matchingRemoteTags) {
                messages.add(" * There is already a tag named " + matchingRemoteTag + " in the remote repo.");
            }
            messages.add("Please try releasing again with a new build number.");
            throw new ValidationException(summary, messages);
        }
        return tags;
    }
}

