/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Guard;

public class VersionName {
    private final String version;
    private final long buildNumber;
    private final String developmentVersion;
    private final String delimiter;

    public VersionName(String developmentVersion, String version, long buildNumber, String delimiter) {
        Guard.notBlank("developmentVersion", developmentVersion);
        Guard.notBlank("version", version);
        Guard.notNull("buildNumber", buildNumber);
        this.version = version;
        this.buildNumber = buildNumber;
        this.developmentVersion = developmentVersion;
        this.delimiter = delimiter;
    }

    public VersionName(String developmentVersion, String version, long buildNumber) {
        this(developmentVersion, version, buildNumber, ".");
    }

    public String businessVersion() {
        return this.version;
    }

    public long buildNumber() {
        return this.buildNumber;
    }

    public String developmentVersion() {
        return this.developmentVersion;
    }

    public String releaseVersion() {
        return this.version + this.delimiter + this.buildNumber;
    }
}

