/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.RefWithCommitId;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

class AnnotatedTagFinder {
    private VersionNamer versionNamer;

    AnnotatedTagFinder(VersionNamer versionNamer) {
        this.versionNamer = versionNamer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<AnnotatedTag> tagsForVersion(Git git, String groupId, String artifactId, String versionWithoutBuildNumber, String tagNameFormat, Log log) throws MojoExecutionException {
        ArrayList<AnnotatedTag> results = new ArrayList<AnnotatedTag>();
        try {
            ArrayList<RefWithCommitId> tagCommits = this.getAnnotatedTags(git, groupId, artifactId, versionWithoutBuildNumber, tagNameFormat, log);
            Map<ObjectId, List<RefWithCommitId>> commitTags = tagCommits.stream().collect(Collectors.groupingBy(RefWithCommitId::getCommitObjectId));
            Iterable commits = git.log().call();
            for (RevCommit commit : commits) {
                if (!commitTags.containsKey(commit.getId())) continue;
                for (RefWithCommitId tag : commitTags.get(commit.getId())) {
                    try {
                        results.add(AnnotatedTag.fromRefCommit(git.getRepository(), tag.getRef(), commit));
                    }
                    catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error while looking up tag " + tag, (Exception)e);
                    }
                }
                return results;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new MojoExecutionException("Error while getting a list of annotated tags in the local repo", (Exception)e);
        }
    }

    private ArrayList<RefWithCommitId> getAnnotatedTags(Git git, String groupId, String artifactId, String versionWithoutBuildNumber, String tagNameFormat, Log log) throws GitAPIException, IOException {
        String tagWithoutBuildNumber = artifactId + "-" + versionWithoutBuildNumber;
        if (StringUtils.isNotEmpty((String)tagNameFormat)) {
            tagWithoutBuildNumber = AnnotatedTag.formatTagName(tagWithoutBuildNumber, groupId, artifactId, versionWithoutBuildNumber, tagNameFormat, log);
        }
        ArrayList<RefWithCommitId> allTags = new ArrayList<RefWithCommitId>();
        List tags = git.tagList().call();
        for (Ref ref : tags) {
            if (!this.isPotentiallySameVersionIgnoringBuildNumber(tagWithoutBuildNumber, ref.getName())) continue;
            LogCommand gitLog = git.log();
            Ref peeledRef = git.getRepository().getRefDatabase().peel(ref);
            if (peeledRef.getPeeledObjectId() != null) {
                gitLog.add((AnyObjectId)peeledRef.getPeeledObjectId());
            } else {
                gitLog.add((AnyObjectId)ref.getObjectId());
            }
            RevCommit commit = (RevCommit)gitLog.call().iterator().next();
            allTags.add(new RefWithCommitId(ref, commit.getId()));
        }
        return allTags;
    }

    boolean isPotentiallySameVersionIgnoringBuildNumber(String versionWithoutBuildNumber, String refName) {
        return this.buildNumberOf(versionWithoutBuildNumber, refName) != null;
    }

    Long buildNumberOf(String versionWithoutBuildNumber, String refName) {
        String prefix;
        String tagName = AnnotatedTag.stripRefPrefix(refName);
        if (tagName.startsWith(prefix = versionWithoutBuildNumber + this.versionNamer.getDelimiter())) {
            String end = tagName.substring(prefix.length());
            try {
                return Long.parseLong(end);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

