/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.VersionName;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

public class ReleasableModule {
    private final MavenProject project;
    private final VersionName version;
    private final String tagName;
    private final String tagNameFormat;
    private final String equivalentVersion;
    private final String relativePathToModule;

    public ReleasableModule(MavenProject project, VersionName version, String equivalentVersion, String relativePathToModule, String tagNameFormat, Log log) {
        this.project = project;
        this.version = version;
        this.equivalentVersion = equivalentVersion;
        this.relativePathToModule = relativePathToModule;
        String defaultTagName = project.getArtifactId() + "-" + version.releaseVersion();
        this.tagName = StringUtils.isNotEmpty((String)tagNameFormat) ? AnnotatedTag.formatTagName(defaultTagName, project.getGroupId(), project.getArtifactId(), version.releaseVersion(), tagNameFormat, log) : defaultTagName;
        this.tagNameFormat = tagNameFormat;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getNewVersion() {
        return this.version.releaseVersion();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version.businessVersion();
    }

    public long getBuildNumber() {
        return this.version.buildNumber();
    }

    public boolean isOneOf(List<String> moduleNames) {
        String modulePath = this.project.getBasedir().getName();
        for (String moduleName : moduleNames) {
            if (!modulePath.equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public boolean willBeReleased() {
        return this.equivalentVersion == null;
    }

    public String getVersionToDependOn() {
        return this.willBeReleased() ? this.version.releaseVersion() : this.equivalentVersion;
    }

    public String getRelativePathToModule() {
        return this.relativePathToModule;
    }

    public ReleasableModule createReleasableVersion(Log log) {
        return new ReleasableModule(this.project, this.version, null, this.relativePathToModule, this.tagNameFormat, log);
    }
}

