/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "9.0.2";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_AUTH_PATH = "/auth";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String importFile;
    private String tlsCertFilename;
    private String tlsKeyFilename;
    private boolean useTls = false;

    public KeycloakContainer() {
        this("quay.io/keycloak/keycloak:9.0.2");
    }

    public KeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.setWaitStrategy(Wait.forHttp((String)KEYCLOAK_AUTH_PATH).forPort(8080).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    protected void configure() {
        this.withCommand(new String[]{"-c standalone.xml", "-Dkeycloak.profile.feature.upload_scripts=enabled"});
        this.withEnv("KEYCLOAK_USER", this.adminUsername);
        this.withEnv("KEYCLOAK_PASSWORD", this.adminPassword);
        if (this.useTls && this.isNotBlank(this.tlsCertFilename) && this.isNotBlank(this.tlsKeyFilename)) {
            String certFileInContainer = "/etc/x509/https/tls.crt";
            String keyFileInContainer = "/etc/x509/https/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertFilename), certFileInContainer);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeyFilename), keyFileInContainer);
        }
        if (this.importFile != null) {
            String importFileInContainer = "/tmp/" + this.importFile;
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.importFile), importFileInContainer);
            this.withEnv("KEYCLOAK_IMPORT", importFileInContainer);
        }
    }

    public KeycloakContainer withRealmImportFile(String importFile) {
        this.importFile = importFile;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls() {
        return this.useTls("tls.crt", "tls.key");
    }

    public KeycloakContainer useTls(String tlsCertFilename, String tlsKeyFilename) {
        this.tlsCertFilename = tlsCertFilename;
        this.tlsKeyFilename = tlsKeyFilename;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : "", this.getContainerIpAddress(), this.useTls ? this.getMappedPort(8443) : this.getMappedPort(8080), KEYCLOAK_AUTH_PATH);
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    protected String getKeycloakVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

