/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Objects;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "12.0.1";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_AUTH_PATH = "/auth";
    private static final String DEFAULT_EXTENSION_NAME = "extensions.jar";
    private static final String DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION = "/opt/jboss/keycloak/standalone/deployments";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String importFile;
    private String tlsCertFilename;
    private String tlsKeyFilename;
    private boolean useTls = false;
    private String extensionClassLocation;

    public KeycloakContainer() {
        this("quay.io/keycloak/keycloak:12.0.1");
    }

    public KeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.setWaitStrategy(Wait.forHttp((String)KEYCLOAK_AUTH_PATH).forPort(8080).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    protected void configure() {
        this.withCommand(new String[]{"-c standalone.xml", "-b 0.0.0.0", "-Dkeycloak.profile.feature.upload_scripts=enabled"});
        this.withEnv("KEYCLOAK_USER", this.adminUsername);
        this.withEnv("KEYCLOAK_PASSWORD", this.adminPassword);
        if (this.useTls && this.isNotBlank(this.tlsCertFilename) && this.isNotBlank(this.tlsKeyFilename)) {
            String certFileInContainer = "/etc/x509/https/tls.crt";
            String keyFileInContainer = "/etc/x509/https/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertFilename), certFileInContainer);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeyFilename), keyFileInContainer);
        }
        if (this.importFile != null) {
            String importFileInContainer = "/tmp/" + this.importFile;
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.importFile), importFileInContainer);
            this.withEnv("KEYCLOAK_IMPORT", importFileInContainer);
        }
        if (this.extensionClassLocation != null) {
            this.createKeycloakExtensionDeployment(this.extensionClassLocation);
        }
    }

    public void createKeycloakExtensionDeployment(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION, DEFAULT_EXTENSION_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation");
        Objects.requireNonNull(extensionName, "extensionName");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (!new File(classesLocation).exists()) {
            return;
        }
        String uniqueExtensionNameForExtensionClassFolder = extensionClassFolder.hashCode() + "-" + extensionName;
        String explodedFolderExtensionsJar = deploymentLocation + "/" + uniqueExtensionNameForExtensionClassFolder;
        this.addFileSystemBind(classesLocation, explodedFolderExtensionsJar, BindMode.READ_WRITE, SelinuxContext.SINGLE);
        boolean wildflyDeployment = deploymentLocation.contains("/standalone/deployments");
        if (wildflyDeployment) {
            this.createDeploymentTriggerFileForWildfly(explodedFolderExtensionsJar);
        }
    }

    private void createDeploymentTriggerFileForWildfly(String explodedFolderExtensionsJar) {
        String deploymentTriggerContainerFile = explodedFolderExtensionsJar + ".dodeploy";
        try {
            File deploymentTriggerFile = File.createTempFile("kc-tc-deploy", null);
            deploymentTriggerFile.deleteOnExit();
            Files.write(deploymentTriggerFile.toPath(), "true".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.withFileSystemBind(deploymentTriggerFile.getAbsolutePath(), deploymentTriggerContainerFile, BindMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create extensions deployment trigger file", e);
        }
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        String moduleFolder = MountableFile.forClasspathResource((String)".").getResolvedPath() + "/../../";
        return moduleFolder + extensionClassFolder;
    }

    public KeycloakContainer withRealmImportFile(String importFile) {
        this.importFile = importFile;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withExtensionClassesFrom(String classesLocation) {
        this.extensionClassLocation = classesLocation;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls() {
        return this.useTls("tls.crt", "tls.key");
    }

    public KeycloakContainer useTls(String tlsCertFilename, String tlsKeyFilename) {
        this.tlsCertFilename = tlsCertFilename;
        this.tlsKeyFilename = tlsKeyFilename;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : "", this.getContainerIpAddress(), this.useTls ? this.getMappedPort(8443) : this.getMappedPort(8080), KEYCLOAK_AUTH_PATH);
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    protected String getKeycloakVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

