/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "13.0.1";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(2L);
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_AUTH_PATH = "/auth";
    private static final String DB_VENDOR = "h2";
    private static final String DEFAULT_EXTENSION_NAME = "extensions.jar";
    private static final String DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION = "/opt/jboss/keycloak/standalone/deployments";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String dbVendor = "h2";
    private String importFile;
    private String tlsCertFilename;
    private String tlsKeyFilename;
    private boolean useTls = false;
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private String extensionClassLocation;
    private static final Transferable WILDFLY_DEPLOYMENT_TRIGGER_FILE_CONTENT = Transferable.of((byte[])"true".getBytes(StandardCharsets.UTF_8));
    private final Set<String> wildflyDeploymentTriggerFiles = new HashSet<String>();

    public KeycloakContainer() {
        this("quay.io/keycloak/keycloak:13.0.1");
    }

    public KeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
    }

    protected void configure() {
        this.withCommand(new String[]{"-c standalone.xml", "-b 0.0.0.0", "-Dkeycloak.profile.feature.upload_scripts=enabled"});
        this.setWaitStrategy(Wait.forHttp((String)KEYCLOAK_AUTH_PATH).forPort(8080).withStartupTimeout(this.startupTimeout));
        this.withEnv("KEYCLOAK_USER", this.adminUsername);
        this.withEnv("KEYCLOAK_PASSWORD", this.adminPassword);
        this.withEnv("DB_VENDOR", this.dbVendor);
        if (this.useTls && this.isNotBlank(this.tlsCertFilename) && this.isNotBlank(this.tlsKeyFilename)) {
            String certFileInContainer = "/etc/x509/https/tls.crt";
            String keyFileInContainer = "/etc/x509/https/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertFilename), certFileInContainer);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeyFilename), keyFileInContainer);
        }
        if (this.importFile != null) {
            String importFileInContainer = "/tmp/" + this.importFile;
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.importFile), importFileInContainer);
            this.withEnv("KEYCLOAK_IMPORT", importFileInContainer);
        }
        if (this.extensionClassLocation != null) {
            this.createKeycloakExtensionDeployment(this.extensionClassLocation);
        }
    }

    public void createKeycloakExtensionDeployment(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION, DEFAULT_EXTENSION_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation");
        Objects.requireNonNull(extensionName, "extensionName");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (!new File(classesLocation).exists()) {
            return;
        }
        String explodedFolderName = extensionClassFolder.hashCode() + "-" + extensionName;
        String explodedFolderExtensionsJar = deploymentLocation + "/" + explodedFolderName;
        this.addFileSystemBind(classesLocation, explodedFolderExtensionsJar, BindMode.READ_WRITE, SelinuxContext.SINGLE);
        boolean wildflyDeployment = deploymentLocation.contains("/standalone/deployments");
        if (wildflyDeployment) {
            this.registerWildflyDeploymentTriggerFile(deploymentLocation, explodedFolderName);
            this.setWaitStrategy((WaitStrategy)this.createCombinedWaitAllStrategy((WaitStrategy)Wait.forLogMessage((String)(".* Deployed \"" + explodedFolderName + "\" .*"), (int)1)));
        }
    }

    private WaitAllStrategy createCombinedWaitAllStrategy(WaitStrategy waitStrategy) {
        WaitAllStrategy waitAll = new WaitAllStrategy();
        waitAll.withStartupTimeout(this.startupTimeout);
        WaitStrategy currentWaitStrategy = this.getWaitStrategy();
        if (currentWaitStrategy != null) {
            waitAll.withStrategy(currentWaitStrategy);
        }
        waitAll.withStrategy(waitStrategy);
        return waitAll;
    }

    private void registerWildflyDeploymentTriggerFile(String deploymentLocation, String extensionArtifact) {
        String triggerFileName = extensionArtifact + ".dodeploy";
        this.wildflyDeploymentTriggerFiles.add(deploymentLocation + "/" + triggerFileName);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.createWildflyDeploymentTriggerFiles();
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        this.wildflyDeploymentTriggerFiles.clear();
    }

    private void createWildflyDeploymentTriggerFiles() {
        this.wildflyDeploymentTriggerFiles.forEach(deploymentTriggerFile -> this.copyFileToContainer(WILDFLY_DEPLOYMENT_TRIGGER_FILE_CONTENT, (String)deploymentTriggerFile));
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        String moduleFolder = MountableFile.forClasspathResource((String)".").getResolvedPath() + "/../../";
        return moduleFolder + extensionClassFolder;
    }

    public KeycloakContainer withRealmImportFile(String importFile) {
        this.importFile = importFile;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withDbVendor(String dbVendor) {
        this.dbVendor = dbVendor;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withExtensionClassesFrom(String classesLocation) {
        this.extensionClassLocation = classesLocation;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls() {
        return this.useTls("tls.crt", "tls.key");
    }

    public KeycloakContainer withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls(String tlsCertFilename, String tlsKeyFilename) {
        this.tlsCertFilename = tlsCertFilename;
        this.tlsKeyFilename = tlsKeyFilename;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : "", this.getContainerIpAddress(), this.useTls ? this.getMappedPort(8443) : this.getMappedPort(8080), KEYCLOAK_AUTH_PATH);
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    protected String getKeycloakVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

